/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.jboss.PassivationConfig;
import org.jboss.metadata.web.jboss.ReplicationConfig;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.JBossManagerMBean;
import org.jboss.web.tomcat.service.session.SessionIDGenerator;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;
import org.jboss.web.tomcat.statistics.ReplicationStatistics;

public abstract class JBossManager
implements AbstractJBossManager,
Lifecycle,
JBossManagerMBean,
PropertyChangeListener {
    private static final String info_ = "JBossManager/1.0";
    protected ReplicationStatistics stats_ = new ReplicationStatistics();
    protected ReplicationTrigger replicationTrigger_;
    protected boolean passivationMode_ = false;
    protected int passivationMinIdleTime_ = -1;
    protected int passivationMaxIdleTime_ = -1;
    protected LifecycleSupport lifecycle_ = new LifecycleSupport((Lifecycle)this);
    protected boolean started_ = false;
    protected ObjectName objectName_;
    protected Logger log_ = Logger.getLogger((String)this.getClass().getName());
    protected Container container_;
    protected boolean distributable_ = true;
    protected int maxInactiveInterval_ = 60;
    protected int sessionIdLength_ = 16;
    protected int maxActive_ = -1;
    protected int createdCounter_ = 0;
    protected volatile int rejectedCounter_ = 0;
    protected int activeCounter_ = 0;
    protected int maxActiveCounter_ = 0;
    protected volatile int expiredCounter_ = 0;
    protected long timeSinceLastReset_ = 0L;
    protected long processingTime_ = 0L;
    protected final Map sessions_ = new ConcurrentHashMap();
    protected boolean useLocalCache_ = true;
    protected PropertyChangeSupport support_ = new PropertyChangeSupport(this);
    protected SessionIDGenerator sessionIDGenerator_ = SessionIDGenerator.getInstance();
    protected String jvmRoute_;

    public void init(String name, JBossWebMetaData webMetaData) throws ClusteringNotSupportedException {
        PassivationConfig pConfig;
        ReplicationConfig rpc = webMetaData.getReplicationConfig();
        if (rpc != null) {
            this.replicationTrigger_ = rpc.getReplicationTrigger();
        }
        if (webMetaData.getMaxActiveSessions() != null) {
            this.maxActive_ = webMetaData.getMaxActiveSessions();
        }
        if ((pConfig = webMetaData.getPassivationConfig()) != null && pConfig.getUseSessionPassivation() != null) {
            this.passivationMode_ = pConfig.getUseSessionPassivation();
            if (this.passivationMode_) {
                Integer max;
                Integer min = pConfig.getPassivationMinIdleTime();
                if (min != null) {
                    this.passivationMinIdleTime_ = min;
                }
                if ((max = pConfig.getPassivationMaxIdleTime()) != null) {
                    this.passivationMaxIdleTime_ = max;
                }
            }
        }
        this.log_.debug((Object)("init(): replicationTrigger is " + this.replicationTrigger_ + " and maxActiveSessions allowed is " + this.maxActive_ + " and passivationMode is " + this.passivationMode_));
        try {
            this.objectName_ = new ObjectName("jboss.web:service=ClusterManager,WebModule=" + name);
        }
        catch (Throwable e) {
            this.log_.error((Object)"Could not create ObjectName", e);
            throw new ClusteringNotSupportedException(e.toString());
        }
    }

    public ReplicationTrigger getReplicationTrigger() {
        return this.replicationTrigger_;
    }

    public void setReplicationTrigger(ReplicationTrigger trigger) {
        this.replicationTrigger_ = trigger;
    }

    public Engine getEngine() {
        Engine e = null;
        for (Container c = this.getContainer(); e == null && c != null; c = c.getParent()) {
            if (c == null || !(c instanceof Engine)) continue;
            e = (Engine)c;
        }
        return e;
    }

    public String getJvmRoute() {
        if (this.jvmRoute_ == null) {
            Engine e = this.getEngine();
            this.jvmRoute_ = e == null ? null : e.getJvmRoute();
        }
        return this.jvmRoute_;
    }

    protected String getNextId() {
        return this.sessionIDGenerator_.getSessionId();
    }

    public ObjectName getObjectName() {
        return this.objectName_;
    }

    public boolean isUseLocalCache() {
        return this.useLocalCache_;
    }

    public void setSessionCookie(String sessionId) {
        Response response = SessionReplicationContext.getOriginalResponse();
        this.setNewSessionCookie(sessionId, (HttpServletResponse)response);
    }

    public void setNewSessionCookie(String sessionId, HttpServletResponse response) {
        if (response != null) {
            Context context = (Context)this.container_;
            Connector connector = ((Response)response).getConnector();
            if (context.getCookies()) {
                Cookie newCookie = new Cookie(Globals.SESSION_COOKIE_NAME, sessionId);
                if (this.log_.isTraceEnabled()) {
                    this.log_.trace((Object)("Setting cookie with session id:" + sessionId + " & name:" + Globals.SESSION_COOKIE_NAME));
                }
                newCookie.setPath("/");
                newCookie.setMaxAge(-1);
                if (connector.getSecure()) {
                    newCookie.setSecure(true);
                }
                response.addCookie(newCookie);
            }
        }
    }

    public int getMaxActiveAllowed() {
        return this.getMaxActive();
    }

    public void setMaxActiveAllowed(int maxActive) {
        this.setMaxActive(maxActive);
    }

    public long getMaxActiveSessionCount() {
        return this.maxActiveCounter_;
    }

    public ReplicationStatistics getReplicationStatistics() {
        return this.stats_;
    }

    public void resetStats() {
        this.stats_.resetStats();
        this.activeCounter_ = 0;
        this.maxActiveCounter_ = 0;
        this.rejectedCounter_ = 0;
        this.createdCounter_ = 0;
        this.expiredCounter_ = 0;
        this.processingTime_ = 0L;
        this.timeSinceLastReset_ = System.currentTimeMillis();
    }

    public long timeInSecondsSinceLastReset() {
        return (System.currentTimeMillis() - this.timeSinceLastReset_) / 1000L;
    }

    public long getActiveSessionCount() {
        return this.getActiveSessions();
    }

    public long getCreatedSessionCount() {
        return this.createdCounter_;
    }

    public long getExpiredSessionCount() {
        return this.expiredCounter_;
    }

    public long getRejectedSessionCount() {
        return this.rejectedCounter_;
    }

    public int getSessionMaxAliveTime() {
        return 0;
    }

    public void setSessionMaxAliveTime(int sessionMaxAliveTime) {
    }

    public int getSessionAverageAliveTime() {
        return 0;
    }

    public void setSessionAverageAliveTime(int sessionAverageAliveTime) {
    }

    public String reportReplicationStatistics() {
        StringBuffer tmp = new StringBuffer();
        HashMap copy = new HashMap(this.stats_.getStats());
        Iterator iter = copy.entrySet().iterator();
        tmp.append("<table><tr>");
        tmp.append("<th>sessionID</th>");
        tmp.append("<th>replicationCount</th>");
        tmp.append("<th>minPassivationTime</th>");
        tmp.append("<th>maxPassivationTime</th>");
        tmp.append("<th>totalPassivationTime</th>");
        tmp.append("<th>minReplicationTime</th>");
        tmp.append("<th>maxReplicationTime</th>");
        tmp.append("<th>totalReplicationlTime</th>");
        tmp.append("<th>loadCount</th>");
        tmp.append("<th>minLoadTime</th>");
        tmp.append("<th>maxLoadTime</th>");
        tmp.append("<th>totalLoadTime</th>");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ReplicationStatistics.TimeStatistic stat = (ReplicationStatistics.TimeStatistic)entry.getValue();
            if (stat == null) continue;
            tmp.append("<tr><td>");
            tmp.append(entry.getKey());
            tmp.append("</td><td>");
            tmp.append(stat.replicationCount);
            tmp.append("</td><td>");
            tmp.append(stat.minPassivationTime);
            tmp.append("</td><td>");
            tmp.append(stat.maxPassivationTime);
            tmp.append("</td><td>");
            tmp.append(stat.totalPassivationTime);
            tmp.append("</td><td>");
            tmp.append(stat.minReplicationTime);
            tmp.append("</td><td>");
            tmp.append(stat.maxReplicationTime);
            tmp.append("</td><td>");
            tmp.append(stat.totalReplicationlTime);
            tmp.append("</td><td>");
            tmp.append(stat.loadCount);
            tmp.append("</td><td>");
            tmp.append(stat.minLoadTime);
            tmp.append("</td><td>");
            tmp.append(stat.maxLoadTime);
            tmp.append("</td><td>");
            tmp.append(stat.totalLoadlTime);
            tmp.append("</td></tr>");
        }
        tmp.append("</table>");
        copy.clear();
        return tmp.toString();
    }

    public String reportReplicationStatisticsCSV() {
        StringBuffer tmp = this.createCSVHeader();
        HashMap copy = new HashMap(this.stats_.getStats());
        for (Map.Entry entry : copy.entrySet()) {
            ReplicationStatistics.TimeStatistic stat = (ReplicationStatistics.TimeStatistic)entry.getValue();
            if (stat == null) continue;
            tmp.append("\n");
            tmp.append(entry.getKey());
            tmp.append(",");
            tmp.append(stat.replicationCount);
            tmp.append(",");
            tmp.append(stat.minPassivationTime);
            tmp.append(",");
            tmp.append(stat.maxPassivationTime);
            tmp.append(",");
            tmp.append(stat.totalPassivationTime);
            tmp.append(",");
            tmp.append(stat.minReplicationTime);
            tmp.append(",");
            tmp.append(stat.maxReplicationTime);
            tmp.append(",");
            tmp.append(stat.totalReplicationlTime);
            tmp.append(",");
            tmp.append(stat.loadCount);
            tmp.append(",");
            tmp.append(stat.minLoadTime);
            tmp.append(",");
            tmp.append(stat.maxLoadTime);
            tmp.append(",");
            tmp.append(stat.totalLoadlTime);
        }
        copy.clear();
        return tmp.toString();
    }

    public String reportReplicationStatisticsCSV(String sessionId) {
        StringBuffer tmp = this.createCSVHeader();
        Map stats = this.stats_.getStats();
        ReplicationStatistics.TimeStatistic stat = (ReplicationStatistics.TimeStatistic)stats.get(sessionId);
        if (stat != null) {
            tmp.append("\n");
            tmp.append(sessionId);
            tmp.append(",");
            tmp.append(stat.replicationCount);
            tmp.append(",");
            tmp.append(stat.minPassivationTime);
            tmp.append(",");
            tmp.append(stat.maxPassivationTime);
            tmp.append(",");
            tmp.append(stat.totalPassivationTime);
            tmp.append(",");
            tmp.append(stat.minReplicationTime);
            tmp.append(",");
            tmp.append(stat.maxReplicationTime);
            tmp.append(",");
            tmp.append(stat.totalReplicationlTime);
            tmp.append(",");
            tmp.append(stat.loadCount);
            tmp.append(",");
            tmp.append(stat.minLoadTime);
            tmp.append(",");
            tmp.append(stat.maxLoadTime);
            tmp.append(",");
            tmp.append(stat.totalLoadlTime);
        }
        return tmp.toString();
    }

    private StringBuffer createCSVHeader() {
        StringBuffer tmp = new StringBuffer();
        tmp.append("sessionID,");
        tmp.append("replicationCount,");
        tmp.append("minPassivationTime,");
        tmp.append("maxPassivationTime,");
        tmp.append("totalPassivationTime,");
        tmp.append("minReplicationTime,");
        tmp.append("maxReplicationTime,");
        tmp.append("totalReplicationlTime,");
        tmp.append("loadCount,");
        tmp.append("minLoadTime,");
        tmp.append("maxLoadTime,");
        tmp.append("totalLoadTime");
        return tmp;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle_.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle_.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle_.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        this.startManager();
    }

    public void stop() throws LifecycleException {
        this.resetStats();
        this.stopManager();
    }

    protected void startManager() throws LifecycleException {
        this.log_.debug((Object)"Starting JBossManager");
        if (this.started_) {
            throw new LifecycleException("JBossManager alreadyStarted");
        }
        this.lifecycle_.fireLifecycleEvent("start", null);
        this.started_ = true;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            server.registerMBean(this, this.objectName_);
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not register ClusterManagerMBean to MBeanServer", (Throwable)e);
        }
    }

    protected void stopManager() throws LifecycleException {
        this.log_.debug((Object)"Stopping JBossManager");
        if (!this.started_) {
            throw new LifecycleException("JBossManager notStarted");
        }
        this.lifecycle_.fireLifecycleEvent("stop", null);
        this.started_ = false;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            server.unregisterMBean(this.objectName_);
        }
        catch (Exception e) {
            this.log_.error((Object)"Could not unregister ClusterManagerMBean from MBeanServer", (Throwable)e);
        }
    }

    public Container getContainer() {
        return this.container_;
    }

    public void setContainer(Container container) {
        if (this.container_ != null && this.container_ instanceof Context) {
            this.container_.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.container_ = container;
        if (this.container_ != null && this.container_ instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container_).getSessionTimeout() * 60);
            this.container_.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public boolean getDistributable() {
        return this.distributable_;
    }

    public void setDistributable(boolean distributable) {
        this.distributable_ = distributable;
    }

    public String getInfo() {
        return info_;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval_;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval_ = interval;
    }

    public int getSessionIdLength() {
        return this.sessionIdLength_;
    }

    public void setSessionIdLength(int idLength) {
        this.sessionIdLength_ = idLength;
    }

    public int getSessionCounter() {
        return this.createdCounter_;
    }

    public void setSessionCounter(int sessionCounter) {
        this.createdCounter_ = sessionCounter;
    }

    public int getMaxActive() {
        return this.maxActive_;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive_ = maxActive;
    }

    public int getExpiredSessions() {
        return this.expiredCounter_;
    }

    public void setExpiredSessions(int expiredSessions) {
        this.expiredCounter_ = expiredSessions;
    }

    public int getRejectedSessions() {
        return this.rejectedCounter_;
    }

    public void setRejectedSessions(int rejectedSessions) {
        this.rejectedCounter_ = rejectedSessions;
    }

    public long getProcessingTime() {
        return this.processingTime_;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support_.addPropertyChangeListener(listener);
    }

    public abstract void removeLocal(Session var1);

    public abstract boolean storeSession(Session var1);

    public int getActiveSessions() {
        return this.activeCounter_;
    }

    public void load() throws ClassNotFoundException, IOException {
        throw new RuntimeException("JBossManager.load(): Method not implemented.");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support_.removePropertyChangeListener(listener);
    }

    public void unload() throws IOException {
        throw new RuntimeException("JBossManager.load(): Method not implemented.");
    }

    public void backgroundProcess() {
        long start = System.currentTimeMillis();
        this.processExpires();
        long elapsed = System.currentTimeMillis() - start;
        this.processingTime_ += elapsed;
    }

    protected abstract void processExpires();

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public abstract ClusteredSession[] findLocalSessions();

    public abstract ClusteredSession findLocalSession(String var1);
}

