/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.jboss.logging.Logger;

public class SessionIDGenerator {
    protected static final int SESSION_ID_BYTES = 16;
    protected static final String SESSION_ID_HASH_ALGORITHM = "MD5";
    protected static final String SESSION_ID_RANDOM_ALGORITHM = "SHA1PRNG";
    protected static final String SESSION_ID_RANDOM_ALGORITHM_ALT = "IBMSecureRandom";
    protected Logger log = Logger.getLogger(SessionIDGenerator.class);
    protected MessageDigest digest = null;
    protected Random random = null;
    protected static SessionIDGenerator s_;
    protected String sessionIdAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-_";

    public static SessionIDGenerator getInstance() {
        if (s_ == null) {
            s_ = new SessionIDGenerator();
        }
        return s_;
    }

    public void setSessionIdAlphabet(String sessionIdAlphabet) {
        if (sessionIdAlphabet.length() != 65) {
            throw new IllegalArgumentException("SessionIdAlphabet must be exactly 65 characters long");
        }
        this.checkDuplicateChars(sessionIdAlphabet);
        this.sessionIdAlphabet = sessionIdAlphabet;
    }

    protected void checkDuplicateChars(String sessionIdAlphabet) {
        char[] alphabet = sessionIdAlphabet.toCharArray();
        for (int i = 0; i < alphabet.length; ++i) {
            if (this.uniqueChar(alphabet[i], sessionIdAlphabet)) continue;
            throw new IllegalArgumentException("All chars in SessionIdAlphabet must be unique");
        }
    }

    protected boolean uniqueChar(char c, String s) {
        int firstIndex = s.indexOf(c);
        if (firstIndex == -1) {
            return false;
        }
        return s.indexOf(c, firstIndex + 1) == -1;
    }

    public String getSessionIdAlphabet() {
        return this.sessionIdAlphabet;
    }

    public synchronized String getSessionId() {
        String id = this.generateSessionId();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("getSessionId() called: " + id));
        }
        return id;
    }

    protected synchronized String generateSessionId() {
        if (this.digest == null) {
            this.digest = this.getDigest();
        }
        if (this.random == null) {
            this.random = this.getRandom();
        }
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        bytes = this.digest.digest(bytes);
        return this.encode(bytes);
    }

    protected String encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        char[] alphabet = this.sessionIdAlphabet.toCharArray();
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    protected synchronized Random getRandom() {
        SecureRandom random = null;
        long seed = System.currentTimeMillis();
        seed ^= Runtime.getRuntime().freeMemory();
        try {
            random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            try {
                random = SecureRandom.getInstance(SESSION_ID_RANDOM_ALGORITHM_ALT);
            }
            catch (NoSuchAlgorithmException e_alt) {
                this.log.error((Object)"Could not generate SecureRandom for session-id randomness", (Throwable)e);
                this.log.error((Object)"Could not generate SecureRandom for session-id randomness", (Throwable)e_alt);
                return null;
            }
        }
        ((Random)random).setSeed(seed);
        return random;
    }

    protected synchronized MessageDigest getDigest() {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(SESSION_ID_HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error((Object)"Could not generate MessageDigest for session-id hashing", (Throwable)e);
            return null;
        }
        return digest;
    }
}

