/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.web.metamodel.descriptor;

import java.io.Serializable;

import org.jboss.logging.Logger;


/**
 * Represents a <passivation-config> element of the jboss-web.xml 
 * deployment descriptor 
 *
 * @author Brian Stansberry
 * @version <tt>$Revision: 65351 $</tt>
 */
public class PassivationConfig
   implements Serializable
{  
   /** The serialVersionUID */
   private static final long serialVersionUID = 107046298420138708L;

   private static final Logger log = Logger.getLogger(PassivationConfig.class);
   private static final String IGNORE = "-1";
   
   /**
    * If true then the session passivation is enabled for this web app.
    * If false then the session passivation is disabled for this web app. 
    */
   protected String useSessionPassivation;
   
   /**
    * Min time (seconds) the session must be idle since lastAccesstime before it's eligable for passivation
    * This overrides maxActive_, to prevent thrashing if the there are lots of active sessions.
    * Setting to -1 means it's ignored
    */
   protected String passivationMinIdleTime;
   
   /**
    * Max time (seconds) the session must be idle since lastAccesstime before it's eligable for passivation
    * This overrides maxActive_, to prevent thrashing if the there are lots of active sessions.
    * Setting to -1 means session should not be forced out.
    */
   protected String passivationMaxIdleTime;

   public String getPassivationMaxIdleTime()
   {
      return passivationMaxIdleTime == null ? IGNORE : passivationMaxIdleTime;
   }

   public void setPassivationMaxIdleTime(String passivationMaxIdleTime)
   {
      this.passivationMaxIdleTime = passivationMaxIdleTime;
   }

   public String getPassivationMinIdleTime()
   {
      return passivationMinIdleTime == null ? IGNORE : passivationMinIdleTime;
   }

   public void setPassivationMinIdleTime(String passivationMinIdleTime)
   {
      this.passivationMinIdleTime = passivationMinIdleTime;
   }

   public String getUseSessionPassivation()
   {
      return useSessionPassivation;
   }

   public void setUseSessionPassivation(String useSessionPassivation)
   {
      this.useSessionPassivation = useSessionPassivation;
   }
   
}
