/*
  * JBoss, Home of Professional Open Source
  * Copyright 2007, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.PrivilegedActionException;

import javax.servlet.ServletException;

import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SecurityUtil;

//$Id$

/**
 *  Establish the Security Context
 *  @author Anil.Saldhana@redhat.com
 *  @since  Sep 12, 2007 
 *  @version $Revision$
 */
public class SecurityContextEstablishmentValve extends ValveBase
{  
   private String configuredSecurityDomainName;
   private String securityContextClassName;
   private String defaultSecurityDomain;
   private ISecurityManagement securityManagement;

   public SecurityContextEstablishmentValve(String configuredSecurityDomain, 
         String defaultSecurityDomain, String fqnClass,
         ISecurityManagement securityManagement)
   {
      this.configuredSecurityDomainName = configuredSecurityDomain;
      this.defaultSecurityDomain = defaultSecurityDomain;
      this.securityContextClassName = fqnClass;
      this.securityManagement = securityManagement;
   }
   
   @Override
   public void invoke(Request request, Response response)
   throws IOException, ServletException
   { 
      boolean createdSecurityContext = false;
      //Set the security context if one is unavailable
      SecurityContext sc = SecurityAssociationActions.getSecurityContext();
      if(sc == null)
      {
         String securityDomain = configuredSecurityDomainName;
         if(securityDomain != null)
            securityDomain = securityDomain.trim();
         
         if(securityDomain == null)
            securityDomain = SecurityUtil.unprefixSecurityDomain(defaultSecurityDomain);
         else
            securityDomain = SecurityUtil.unprefixSecurityDomain(securityDomain);
         try
         {
            sc = SecurityAssociationActions.createSecurityContext(securityDomain,
                  this.securityContextClassName); 
         }
         catch (PrivilegedActionException e)
         {
            throw new RuntimeException(e);
         } 
         sc.setSecurityManagement(securityManagement);
         SecurityAssociationActions.setSecurityContext(sc);
         createdSecurityContext = true;
      }
      
      try
      { 
         // Perform the request
         getNext().invoke(request, response);
      }
      finally
      { 
         SecurityRolesAssociation.setSecurityRoles(null); 
         if(createdSecurityContext)
         {
            SecurityAssociationActions.clearSecurityContext();
         }
      }
   } 
}