/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */ 
package org.jboss.web.tomcat.security;

import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

/**
 *  Provides utility static methods for the web security integration
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @version $Revision$
 *  @since  Aug 22, 2006
 */
public class WebUtil
{
   /**
    * Obtain debug information from the servlet request object
    * @param httpRequest
    * @return
    */
   public static String deriveUsefulInfo(HttpServletRequest httpRequest)
   {
      StringBuilder sb = new StringBuilder();
      sb.append("[").append(httpRequest.getContextPath());
      sb.append(":cookies=").append(httpRequest.getCookies()).append(":headers=");
      //Append Header information
      Enumeration<?> en = httpRequest.getHeaderNames();
      for(;en.hasMoreElements();)
      {
         String headerName = (String)en.nextElement();
         sb.append(headerName).append("=");
         sb.append(httpRequest.getHeader(headerName)).append(",");
      }
      sb.append("]");
      //Append Request parameter information
      sb.append("[parameters=");
      Enumeration<?> enparam = httpRequest.getParameterNames();
      for(;enparam.hasMoreElements();)
      {
         String paramName = (String)enparam.nextElement();
         String[] paramValues = httpRequest.getParameterValues(paramName);
         int len = paramValues != null ? paramValues.length : 0;
         for(int i = 0 ; i < len ; i++)
            sb.append(paramValues[i]).append("::"); 
         sb.append(",");
      } 
      sb.append("][attributes=");
      //Append Request attribute information
      Enumeration<?> enu = httpRequest.getAttributeNames();
      for(;enu.hasMoreElements();)
      {
         String attrName = (String)enu.nextElement();
         sb.append(attrName).append("=");
         sb.append(httpRequest.getAttribute(attrName)).append(",");
      }
      sb.append("]");
      return sb.toString();
   } 
}
