/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.web.tomcat.service.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

import org.jboss.ha.framework.interfaces.ObjectStreamSource;
import org.jboss.serial.io.JBossObjectInputStreamSharedTree;
import org.jboss.serial.io.JBossObjectOutputStreamSharedTree;

/**
 * {@link ObjectStreamSource} implementation that provides 
 * {@link JBossObjectInputStreamSharedTree} and {@link JBossObjectOutputStreamSharedTree}.
 * 
 * @author Brian Stansberry
 */
public class JBossSerializationObjectStreamSource implements ObjectStreamSource
{

   public ObjectInput getObjectInput(InputStream input) throws IOException
   {
      return new JBossObjectInputStreamSharedTree(input);
   }

   public ObjectOutput getObjectOutput(OutputStream output) throws IOException
   {
      return new JBossObjectOutputStreamSharedTree(output);
   }

}
