/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.metamodel.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.DDObjectFactory;
import org.jboss.metamodel.descriptor.EjbLocalRef;
import org.jboss.metamodel.descriptor.EjbRef;
import org.jboss.metamodel.descriptor.EnvEntry;
import org.jboss.metamodel.descriptor.MessageDestination;
import org.jboss.metamodel.descriptor.MessageDestinationRef;
import org.jboss.metamodel.descriptor.ResourceEnvRef;
import org.jboss.metamodel.descriptor.ResourceRef;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.web.metamodel.descriptor.PassivationConfig;
import org.jboss.web.metamodel.descriptor.ReplicationConfig;
import org.jboss.web.metamodel.descriptor.SecurityRole;
import org.jboss.web.metamodel.descriptor.Servlet;
import org.jboss.web.metamodel.descriptor.ServletMapping;
import org.jboss.web.metamodel.descriptor.WebDD;
import org.jboss.wsf.spi.serviceref.ServiceRefMetaData;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;

public class JBossWebDDObjectFactory
extends DDObjectFactory {
    private static final Logger log = Logger.getLogger(JBossWebDDObjectFactory.class);
    private WebDD dd;

    public static WebDD parse(URL ddResource, WebDD dd) throws JBossXBException, IOException {
        if (ddResource == null) {
            return null;
        }
        log.debug((Object)("found jboss-web.xml " + ddResource));
        InputStream is = ddResource.openStream();
        return JBossWebDDObjectFactory.parse(dd, is);
    }

    public static WebDD parse(WebDD dd, InputStream is) throws JBossXBException {
        JBossWebDDObjectFactory factory = null;
        Unmarshaller unmarshaller = null;
        if (dd == null) {
            dd = new WebDD();
        }
        factory = new JBossWebDDObjectFactory(dd);
        UnmarshallerFactory unmarshallerFactory = UnmarshallerFactory.newInstance();
        unmarshaller = unmarshallerFactory.newUnmarshaller();
        unmarshaller.setEntityResolver((EntityResolver)new JBossEntityResolver());
        unmarshaller.setNamespaceAware(true);
        unmarshaller.setSchemaValidation(true);
        unmarshaller.setValidation(true);
        dd = (WebDD)((Object)unmarshaller.unmarshal(is, (ObjectModelFactory)factory, null));
        return dd;
    }

    public JBossWebDDObjectFactory(WebDD dd) {
        this.dd = dd;
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return this.dd;
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public Object newChild(WebDD dd, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        Object child = null;
        log.debug((Object)("newChild, " + localName));
        child = this.newEnvRefGroupChild(localName);
        if (child != null) {
            return child;
        }
        if (localName.equals("security-role")) {
            child = new SecurityRole();
        } else if (localName.equals("servlet")) {
            child = new Servlet();
        } else if (localName.equals("replication-config")) {
            child = new ReplicationConfig();
        } else if (localName.equals("passivation-config")) {
            child = new ReplicationConfig();
        } else if (localName.equals("message-destination")) {
            child = new MessageDestination();
        }
        return child;
    }

    public void addChild(WebDD parent, ReplicationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setReplicationConfig(config);
    }

    public void addChild(WebDD parent, PassivationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.setPassivationConfig(config);
    }

    public void addChild(WebDD parent, EjbLocalRef ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.updateEjbLocalRef(ref);
    }

    public void addChild(WebDD parent, EjbRef ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.updateEjbRef(ref);
    }

    public void addChild(WebDD parent, EnvEntry ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.addEnvEntry(ref);
    }

    public void addChild(WebDD parent, MessageDestination destination, UnmarshallingContext navigator, String namespaceURI, String localName) {
        MessageDestinationRef ref;
        log.debug((Object)("addMessageDestination, " + destination));
        parent.updateMessageDestination(destination);
        String link = destination.getMessageDestinationName();
        if (link != null && (ref = parent.getMessageDestinationRefForLink(link)) != null) {
            log.debug((Object)("ressolved " + ref + " to link mapedName: " + destination.getMappedName()));
            ref.setMappedName(destination.getMappedName());
        }
    }

    public void addChild(WebDD parent, MessageDestinationRef ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.debug((Object)("addMessageDestinationRef, " + ref));
        parent.updateMessageDestinationRef(ref);
    }

    public void addChild(WebDD parent, ServiceRefMetaData sref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        String refName = sref.getServiceRefName();
        if (refName == null) {
            throw new IllegalStateException("Invalid service-ref-name: " + refName);
        }
        ServiceRefMetaData targetRef = parent.getServiceRef(refName);
        if (targetRef == null) {
            log.debug((Object)("Cannot find <service-ref> with name: " + refName));
            parent.addServiceRef(sref);
        } else {
            targetRef.merge(sref);
        }
    }

    public void addChild(WebDD parent, ResourceEnvRef ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.updateResourceEnvRef(ref);
    }

    public void addChild(WebDD parent, ResourceRef ref, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.updateResourceRef(ref);
    }

    public void addChild(WebDD parent, SecurityRole role, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.updateSecurityRole(role);
    }

    public void addChild(WebDD parent, Servlet servlet, UnmarshallingContext navigator, String namespaceURI, String localName) {
        parent.updateServlet(servlet);
    }

    public void setValue(WebDD dd, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("depends")) {
            dd.addDependency(value);
        } else if (localName.equals("security-domain")) {
            dd.setSecurityDomain(value);
        }
    }

    public void setValue(ReplicationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("replication-trigger")) {
            config.setTrigger(value);
        } else if (localName.equals("replication-granularity")) {
            config.setGranularity(value);
        } else if (localName.equals("replication-field-batch-mode")) {
            config.setFieldBatchMode(value);
        } else if (localName.equals("cache-name")) {
            config.setCacheName(value);
        } else if (localName.equals("snapshot-mode")) {
            config.setSnapshotMode(value);
        } else if (localName.equals("snapshot-interval")) {
            config.setSnapshotInterval(value);
        } else if (localName.equals("use-jk")) {
            config.setUseJK(value);
        }
    }

    public void setValue(PassivationConfig config, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("use-session-passivation")) {
            config.setUseSessionPassivation(value);
        } else if (localName.equals("passivation-min-idle-time")) {
            config.setPassivationMinIdleTime(value);
        } else if (localName.equals("passivation-max-idle-time")) {
            config.setPassivationMaxIdleTime(value);
        }
    }

    public void setValue(Servlet servlet, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("servlet-name")) {
            servlet.setName(value);
        } else if (localName.equals("run-as-principal")) {
            servlet.addRunAsPrincipal(value);
        }
    }

    public void setValue(ServletMapping mapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("servlet-name")) {
            mapping.setName(value);
        } else if (localName.equals("url-pattern")) {
            mapping.setUrlPattern(value);
        }
    }

    public void setValue(SecurityRole role, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        if (localName.equals("principal-name")) {
            role.setPrincipalName(value);
        } else {
            super.setValue((org.jboss.metamodel.descriptor.SecurityRole)role, navigator, namespaceURI, localName, value);
        }
    }
}

