/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.PrivilegedActionException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SecurityUtil;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class SecurityContextEstablishmentValve
extends ValveBase {
    private String configuredSecurityDomainName;
    private String securityContextClassName;
    private String defaultSecurityDomain;
    private ISecurityManagement securityManagement;

    public SecurityContextEstablishmentValve(String configuredSecurityDomain, String defaultSecurityDomain, String fqnClass, ISecurityManagement securityManagement) {
        this.configuredSecurityDomainName = configuredSecurityDomain;
        this.defaultSecurityDomain = defaultSecurityDomain;
        this.securityContextClassName = fqnClass;
        this.securityManagement = securityManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean createdSecurityContext = false;
        SecurityContext sc = SecurityAssociationActions.getSecurityContext();
        if (sc == null) {
            String securityDomain = this.configuredSecurityDomainName;
            if (securityDomain != null) {
                securityDomain = securityDomain.trim();
            }
            securityDomain = securityDomain == null ? SecurityUtil.unprefixSecurityDomain((String)this.defaultSecurityDomain) : SecurityUtil.unprefixSecurityDomain((String)securityDomain);
            try {
                sc = SecurityAssociationActions.createSecurityContext(securityDomain, this.securityContextClassName);
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e);
            }
            sc.setSecurityManagement(this.securityManagement);
            SecurityAssociationActions.setSecurityContext(sc);
            createdSecurityContext = true;
        }
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            SecurityRolesAssociation.setSecurityRoles(null);
            if (createdSecurityContext) {
                SecurityAssociationActions.clearSecurityContext();
            }
        }
    }
}

