/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.Authenticator;
import org.apache.catalina.startup.ContextConfig;
import org.jboss.logging.Logger;

public class JBossContextConfig
extends ContextConfig {
    private static Logger log = Logger.getLogger(JBossContextConfig.class);
    private boolean isTrace = log.isTraceEnabled();

    public JBossContextConfig() {
        try {
            Map authMap = this.getAuthenticators();
            if (authMap.size() > 0) {
                this.customAuthenticators = authMap;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to customize authenticators::", (Throwable)e);
        }
    }

    private Map getAuthenticators() throws Exception {
        HashMap<String, Authenticator> cmap = new HashMap<String, Authenticator>();
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        Properties authProps = this.getAuthenticatorsFromJndi();
        if (authProps != null) {
            Iterator<Object> iter;
            Set<Object> keys = authProps.keySet();
            Iterator<Object> iterator = iter = keys != null ? keys.iterator() : null;
            while (iter != null && iter.hasNext()) {
                String key = (String)iter.next();
                String authenticatorStr = (String)authProps.get(key);
                Class<?> authClass = tcl.loadClass(authenticatorStr);
                cmap.put(key, (Authenticator)authClass.newInstance());
            }
        }
        if (this.isTrace) {
            log.trace((Object)("Authenticators plugged in::" + cmap));
        }
        return cmap;
    }

    private Properties getAuthenticatorsFromJndi() throws NamingException {
        return (Properties)new InitialContext().lookup("TomcatAuthenticators");
    }
}

