/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.web.tomcat.service.session.JBossCacheClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheService;
import org.jboss.web.tomcat.service.session.SessionReplicationContext;

public class FieldBasedJBossCacheService
extends JBossCacheService {
    private final PojoCache pojoCache_;

    public FieldBasedJBossCacheService(PojoCache cache) {
        super(cache.getCache());
        this.pojoCache_ = cache;
        this.setCache(this.pojoCache_.getCache());
    }

    private Fqn getFieldFqn(String id, String key) {
        return FieldBasedJBossCacheService.getFieldFqn(this.hostName_, this.webAppPath_, id, key);
    }

    private static void breakKeys(String key, List list) {
        StringTokenizer token = new StringTokenizer(key, "/");
        while (token.hasMoreTokens()) {
            list.add(token.nextToken());
        }
    }

    public static Fqn getFieldFqn(String hostName, String contextPath, String sessionId, String attributeKey) {
        ArrayList<String> list = new ArrayList<String>(6);
        list.add("JSESSION");
        list.add(hostName);
        list.add(contextPath);
        list.add(sessionId);
        list.add("ATTRIBUTE");
        FieldBasedJBossCacheService.breakKeys(attributeKey, list);
        return new Fqn(list);
    }

    public Object setPojo(String realId, String key, Object pojo, JBossCacheClusteredSession session) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("setPojo(): session id: " + realId + " key: " + key + " object: " + pojo.toString()));
        }
        if (session.needRegionForSession()) {
            Fqn sessionRegion = this.getSessionFqn(realId);
            this.getCache().getRegion(sessionRegion, true);
            session.createdRegionForSession();
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("Created region for session at " + sessionRegion));
            }
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            SessionReplicationContext.startCacheActivity();
            Object object = this.pojoCache_.attach(fqn.toString(), pojo);
            return object;
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache setPojo ... ", e);
        }
        finally {
            SessionReplicationContext.finishCacheActivity();
        }
    }

    public Object removePojo(String realId, String key) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojo(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            SessionReplicationContext.startCacheActivity();
            Object object = this.pojoCache_.detach(fqn.toString());
            return object;
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache removePojo ... ", e);
        }
        finally {
            SessionReplicationContext.finishCacheActivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePojosLocal(String realId) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojoLocal(): session id: " + realId));
        }
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            SessionReplicationContext.startCacheActivity();
            this.cacheWrapper_.removeLocal(fqn);
        }
        finally {
            SessionReplicationContext.finishCacheActivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePojoLocal(String realId, String key) {
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("removePojoLocal(): session id: " + realId + " key: " + key));
        }
        Fqn fqn = this.getFieldFqn(realId, key);
        try {
            SessionReplicationContext.startCacheActivity();
            this.cacheWrapper_.removeLocal(fqn);
        }
        finally {
            SessionReplicationContext.finishCacheActivity();
        }
    }

    public Set getPojoKeys(String realId) {
        Set keys = null;
        Fqn fqn = this.getAttributeFqn(realId);
        try {
            keys = this.getChildrenNames(fqn);
        }
        catch (CacheException e) {
            log_.error((Object)("getPojoKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Object getPojo(String realId, String key) {
        Fqn fqn = this.getFieldFqn(realId, key);
        if (log_.isTraceEnabled()) {
            log_.trace((Object)("getPojo(): session id: " + realId + " key: " + key + " fqn: " + fqn));
        }
        try {
            return this.pojoCache_.find(fqn);
        }
        catch (CacheException e) {
            throw new RuntimeException("JBossCacheService: exception occurred in cache find ... ", e);
        }
    }
}

