/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.aop.Advised;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheManager;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.ha.framework.server.CacheManagerLocator;
import org.jboss.ha.framework.server.PojoCacheManager;
import org.jboss.ha.framework.server.PojoCacheManagerLocator;
import org.jboss.web.tomcat.service.session.ClusteringNotSupportedException;

public class Util {
    private static final Set immediates = new HashSet<Object>(Arrays.asList(String.class, Boolean.class, Double.class, Float.class, Integer.class, Long.class, Short.class, Character.class, Boolean.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Character.TYPE, Class.class));

    public static PojoCache findPojoCache(String cacheConfigName) throws ClusteringNotSupportedException {
        PojoCacheManager pcm = Util.getManagerForPojoCache(cacheConfigName);
        try {
            return pcm.getPojoCache(cacheConfigName, true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem accessing cache " + cacheConfigName, e);
        }
    }

    public static Cache findPlainCache(String cacheConfigName) throws ClusteringNotSupportedException {
        CacheManager pcm = Util.getManagerForCache(cacheConfigName);
        try {
            return pcm.getCache(cacheConfigName, true);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem accessing cache " + cacheConfigName, e);
        }
    }

    private static PojoCacheManager getManagerForPojoCache(String cacheConfigName) throws ClusteringNotSupportedException {
        PojoCacheManager pcm = null;
        try {
            pcm = PojoCacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
        }
        catch (Throwable t) {
            throw new ClusteringNotSupportedException("Could not access PojoCacheManager for JBossWeb clustering", t);
        }
        if (!pcm.getConfigurationNames().contains(cacheConfigName)) {
            throw new IllegalStateException("PojoCacheManager does not recognize config " + cacheConfigName);
        }
        return pcm;
    }

    private static CacheManager getManagerForCache(String cacheConfigName) throws ClusteringNotSupportedException {
        CacheManager cm = null;
        try {
            cm = CacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
        }
        catch (Throwable t) {
            throw new ClusteringNotSupportedException("Could not access CacheManager for JBossWeb clustering", t);
        }
        if (!cm.getConfigurationNames().contains(cacheConfigName)) {
            throw new IllegalStateException("CacheManager does not recognize config " + cacheConfigName);
        }
        return cm;
    }

    public static String getRealId(String sessionId) {
        int index = sessionId.lastIndexOf(".");
        if (index > 0) {
            return sessionId.substring(0, index);
        }
        return sessionId;
    }

    public static boolean checkPojoType(Object pojo) {
        return pojo instanceof Serializable || pojo instanceof Collection || pojo instanceof Map || pojo instanceof Advised || immediates.contains(pojo.getClass());
    }

    private Util() {
    }
}

