/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Policy;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.security.CertificatePrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityUtil;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.SubjectSecurityManager;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.javaee.AbstractWebAuthorizationHelper;
import org.jboss.security.javaee.SecurityHelperFactory;
import org.jboss.web.tomcat.security.DigestCallbackHandler;
import org.jboss.web.tomcat.security.JBossGenericPrincipal;
import org.jboss.web.tomcat.security.SecurityAssociationActions;
import org.jboss.web.tomcat.security.SecurityAssociationValve;
import org.jboss.web.tomcat.security.WebUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossWebRealm
extends RealmBase {
    static Logger log = Logger.getLogger(JBossWebRealm.class);
    protected CertificatePrincipal certMapping = new SubjectDNMapping();
    private boolean trace = log.isTraceEnabled();
    private static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
    protected String securityDomain = "jboss-web-policy";
    protected boolean unprotectedResourceDelegation = false;
    protected String securityConstraintProviderClass = "";
    protected boolean enableAudit = true;
    protected boolean ignoreBaseDecision = false;
    protected static boolean securityManagerFallback = false;

    public void setCertificatePrincipal(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cpClass = loader.loadClass(className);
            this.certMapping = (CertificatePrincipal)cpClass.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Failed to load CertificatePrincipal: " + className), (Throwable)e);
            this.certMapping = new SubjectDNMapping();
        }
    }

    public void setSecurityConstraintProviderClass(String securityConstraintProviderClass) {
        this.securityConstraintProviderClass = securityConstraintProviderClass;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public void setUnprotectedResourceDelegation(boolean unprotectedResourceDelegation) {
        this.unprotectedResourceDelegation = unprotectedResourceDelegation;
    }

    public void setEnableAudit(boolean enableAudit) {
        this.enableAudit = enableAudit;
    }

    public void setIgnoreBaseDecision(boolean ignoreBaseDecision) {
        this.ignoreBaseDecision = ignoreBaseDecision;
    }

    public Principal authenticate(X509Certificate[] certs) {
        Principal principal;
        block11: {
            principal = null;
            try {
                SubjectSecurityManager securityMgr = this.getSubjectSecurityManager("authenticate(X509Certificate[] certs)");
                if (securityMgr == null) {
                    return null;
                }
                Subject subject = new Subject();
                principal = this.certMapping.toPrinicipal(certs);
                if (securityMgr.isValid(principal, (Object)certs, subject)) {
                    if (this.trace) {
                        log.trace((Object)("User: " + principal + " is authenticated"));
                    }
                    this.securityDomain = securityMgr.getSecurityDomain();
                    SecurityAssociationActions.setPrincipalInfo(principal, certs, subject);
                    RealmMapping realmMapping = null;
                    realmMapping = securityMgr instanceof RealmMapping ? (RealmMapping)securityMgr : this.getRealmMapping();
                    if (realmMapping == null) {
                        log.trace((Object)"RealmMapping is null for authenticate(x509 params)");
                        return null;
                    }
                    Principal oldPrincipal = principal;
                    principal = realmMapping.getPrincipal(oldPrincipal);
                    if (this.trace) {
                        log.trace((Object)("Mapped from input principal: " + oldPrincipal + "to: " + principal));
                    }
                    principal = this.getCachingPrincipal(realmMapping, oldPrincipal, principal, certs, subject);
                    if (this.enableAudit) {
                        this.successAudit(oldPrincipal, principal);
                    }
                } else {
                    if (this.trace) {
                        log.trace((Object)("User: " + principal + " is NOT authenticated"));
                    }
                    if (this.enableAudit) {
                        this.failureAudit(principal);
                    }
                    principal = null;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error during authenticate", (Throwable)e);
                if (!this.enableAudit) break block11;
                this.errorAudit(principal, e);
            }
        }
        return principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        void var9_16;
        block17: {
            block16: {
                Principal principal;
                block15: {
                    Principal principal2;
                    block14: {
                        Object var9_9 = null;
                        Principal caller = SecurityAssociationValve.userPrincipal.get();
                        if (caller == null && username == null && digest == null) {
                            return null;
                        }
                        try {
                            try {
                                DigestCallbackHandler handler = new DigestCallbackHandler(username, nonce, nc, cnonce, qop, realm, md5a2);
                                CallbackHandlerPolicyContextHandler.setCallbackHandler((CallbackHandler)handler);
                                SubjectSecurityManager securityMgr = this.getSubjectSecurityManager("authenticate( digest related)");
                                if (securityMgr == null) {
                                    principal2 = null;
                                    Object var17_23 = null;
                                    break block14;
                                }
                                SimplePrincipal simplePrincipal = new SimplePrincipal(username);
                                Subject subject = new Subject();
                                if (securityMgr.isValid((Principal)simplePrincipal, (Object)digest, subject)) {
                                    log.trace((Object)("User: " + username + " is authenticated"));
                                    this.securityDomain = securityMgr.getSecurityDomain();
                                    SecurityAssociationActions.setPrincipalInfo((Principal)simplePrincipal, digest, subject);
                                    RealmMapping realmMapping = null;
                                    realmMapping = securityMgr instanceof RealmMapping ? (RealmMapping)securityMgr : this.getRealmMapping();
                                    if (realmMapping == null) {
                                        log.trace((Object)"RealmMapping is null for authenticate(digest params)");
                                        principal = null;
                                        break block15;
                                    }
                                    SimplePrincipal oldPrincipal = simplePrincipal;
                                    Principal principal3 = realmMapping.getPrincipal((Principal)oldPrincipal);
                                    if (this.trace) {
                                        log.trace((Object)("Mapped from input principal: " + oldPrincipal + "to: " + principal3));
                                    }
                                    Principal principal4 = this.getCachingPrincipal(realmMapping, (Principal)oldPrincipal, principal3, digest, subject);
                                    if (this.enableAudit) {
                                        this.successAudit((Principal)oldPrincipal, principal4);
                                    }
                                    break block16;
                                }
                                if (this.enableAudit) {
                                    this.failureAudit((Principal)simplePrincipal);
                                }
                                Object var9_13 = null;
                                if (this.trace) {
                                    log.trace((Object)("User: " + username + " is NOT authenticated"));
                                }
                                break block16;
                            }
                            catch (Exception e) {
                                Principal principal5 = null;
                                log.error((Object)"Error during authenticate", (Throwable)e);
                                if (this.enableAudit) {
                                    this.errorAudit(principal5, e);
                                }
                                Object var17_26 = null;
                                CallbackHandlerPolicyContextHandler.setCallbackHandler(null);
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_27 = null;
                            CallbackHandlerPolicyContextHandler.setCallbackHandler(null);
                            throw throwable;
                        }
                    }
                    CallbackHandlerPolicyContextHandler.setCallbackHandler(null);
                    return principal2;
                }
                Object var17_24 = null;
                CallbackHandlerPolicyContextHandler.setCallbackHandler(null);
                return principal;
            }
            Object var17_25 = null;
            CallbackHandlerPolicyContextHandler.setCallbackHandler(null);
        }
        if (this.trace) {
            log.trace((Object)("End authenticate, principal=" + var9_16));
        }
        return var9_16;
    }

    public Principal authenticate(String username, String credentials) {
        Object principal;
        block13: {
            if (this.trace) {
                log.trace((Object)("Begin authenticate, username=" + username));
            }
            principal = null;
            Principal caller = SecurityAssociationValve.userPrincipal.get();
            if (caller == null && username == null && credentials == null) {
                return null;
            }
            try {
                SubjectSecurityManager securityMgr = this.getSubjectSecurityManager("authenticate(username,cred)");
                if (securityMgr == null) {
                    return null;
                }
                principal = new SimplePrincipal(username);
                Subject subject = new Subject();
                if (securityMgr.isValid((Principal)principal, (Object)credentials, subject)) {
                    log.trace((Object)("User: " + username + " is authenticated"));
                    this.securityDomain = securityMgr.getSecurityDomain();
                    SecurityAssociationActions.setPrincipalInfo((Principal)principal, credentials, subject);
                    RealmMapping realmMapping = null;
                    realmMapping = securityMgr instanceof RealmMapping ? (RealmMapping)securityMgr : this.getRealmMapping();
                    if (realmMapping == null) {
                        log.trace((Object)"RealmMapping is null for authenticate(username,cred)");
                        return null;
                    }
                    SimplePrincipal oldPrincipal = principal;
                    principal = realmMapping.getPrincipal((Principal)oldPrincipal);
                    if (this.trace) {
                        log.trace((Object)("Mapped from input principal: " + oldPrincipal + "to: " + principal));
                    }
                    principal = this.getCachingPrincipal(realmMapping, (Principal)oldPrincipal, (Principal)principal, credentials, subject);
                    if (this.enableAudit) {
                        this.successAudit((Principal)oldPrincipal, (Principal)principal);
                    }
                } else {
                    if (this.enableAudit) {
                        this.failureAudit((Principal)principal);
                    }
                    if (this.trace) {
                        log.trace((Object)("User: " + username + " is NOT authenticated"));
                    }
                    principal = null;
                }
            }
            catch (Exception e) {
                principal = null;
                log.error((Object)"Error during authenticate", (Throwable)e);
                if (!this.enableAudit) break block13;
                this.errorAudit((Principal)principal, e);
            }
        }
        if (this.trace) {
            log.trace((Object)("End authenticate, principal=" + principal));
        }
        return principal;
    }

    public Principal authenticate(String username, byte[] credentials) {
        return this.authenticate(username, new String(credentials));
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        SecurityConstraint[] scarr = super.findSecurityConstraints(request, context);
        if ((scarr == null || scarr.length == 0) && this.unprotectedResourceDelegation) {
            scarr = this.getSecurityConstraintsFromProvider(request, context);
        }
        return scarr;
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] securityConstraints, Context context) throws IOException {
        boolean baseDecision;
        boolean ok = false;
        boolean bl = baseDecision = this.ignoreBaseDecision ? true : super.hasResourcePermission(request, response, securityConstraints, context);
        if (baseDecision) {
            Subject caller = this.establishSubjectContext(request.getPrincipal());
            PolicyRegistration policyRegistration = this.getPolicyRegistration();
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            contextMap.put("resourcePermissionCheck", Boolean.TRUE);
            contextMap.put("policyRegistration", policyRegistration);
            contextMap.put("securityConstraints", securityConstraints);
            AbstractWebAuthorizationHelper helper = null;
            try {
                helper = SecurityHelperFactory.getWebAuthorizationHelper((SecurityContext)sc);
            }
            catch (Exception e) {
                log.error((Object)"Exception in obtaining helper", (Throwable)e);
                return false;
            }
            helper.setPolicyRegistration(policyRegistration);
            helper.setEnableAudit(this.enableAudit);
            ok = helper.checkResourcePermission(contextMap, (ServletRequest)request, (ServletResponse)response, caller, PolicyContext.getContextID(), JBossWebRealm.requestURI(request));
        }
        if (this.trace) {
            log.trace((Object)("hasResourcePerm:RealmBase says:" + baseDecision + "::Authz framework says:" + ok + ":final=" + ok));
        }
        if (!ok) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return ok;
    }

    public boolean hasRole(Principal principal, String role) {
        boolean finalDecision;
        boolean baseDecision;
        String servletName = null;
        Request req = SecurityAssociationValve.activeRequest.get();
        Wrapper servlet = req.getWrapper();
        if (servlet != null) {
            servletName = this.getServletName(servlet);
        }
        if (servletName == null) {
            throw new IllegalStateException("servletName is null");
        }
        JBossWebMetaData metaData = SecurityAssociationValve.activeWebMetaData.get();
        String roleName = role;
        if (metaData != null) {
            ServletMetaData servletMD = (ServletMetaData)metaData.getServlets().get(servletName);
            SecurityRoleRefsMetaData roleRefs = null;
            if (servletMD != null) {
                roleRefs = servletMD.getSecurityRoleRefs();
            }
            if (roleRefs != null) {
                for (SecurityRoleRefMetaData ref : roleRefs) {
                    if (!ref.getRoleLink().equals(role)) continue;
                    roleName = ref.getName();
                    break;
                }
            }
        }
        boolean authzDecision = false;
        boolean bl = baseDecision = this.ignoreBaseDecision ? true : super.hasRole(principal, role);
        if (baseDecision) {
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            AbstractWebAuthorizationHelper helper = null;
            try {
                helper = SecurityHelperFactory.getWebAuthorizationHelper((SecurityContext)sc);
            }
            catch (Exception e) {
                log.error((Object)"Error obtaining helper", (Throwable)e);
            }
            helper.setPolicyRegistration(this.getPolicyRegistration());
            helper.setEnableAudit(this.enableAudit);
            Subject callerSubject = SecurityAssociationActions.getSubject();
            if (callerSubject == null) {
                callerSubject = SecurityAssociationActions.getSubjectFromRequestPrincipal(principal);
            }
            authzDecision = helper.hasRole(roleName, principal, servletName, this.getPrincipalRoles(principal), PolicyContext.getContextID(), callerSubject);
        }
        boolean bl2 = finalDecision = baseDecision && authzDecision;
        if (this.trace) {
            log.trace((Object)("hasRole:RealmBase says:" + baseDecision + "::Authz framework says:" + authzDecision + ":final=" + finalDecision));
        }
        return finalDecision;
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        boolean ok;
        boolean bl = ok = this.ignoreBaseDecision ? true : super.hasUserDataPermission(request, response, constraints);
        if (ok) {
            Principal requestPrincipal = request.getPrincipal();
            this.establishSubjectContext(requestPrincipal);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("securityConstraints", constraints);
            map.put("userDataPermissionCheck", Boolean.TRUE);
            SecurityContext sc = SecurityAssociationActions.getSecurityContext();
            AbstractWebAuthorizationHelper helper = null;
            try {
                helper = SecurityHelperFactory.getWebAuthorizationHelper((SecurityContext)sc);
            }
            catch (Exception e) {
                log.error((Object)"Error obtaining helper", (Throwable)e);
            }
            helper.setPolicyRegistration(this.getPolicyRegistration());
            helper.setEnableAudit(this.enableAudit);
            ok = helper.hasUserDataPermission(map, (ServletRequest)request, (ServletResponse)response, PolicyContext.getContextID(), SecurityAssociationActions.getSubject());
        }
        return ok;
    }

    protected Principal getCachingPrincipal(RealmMapping realmMapping, Principal authPrincipal, Principal callerPrincipal, Object credential, Subject subject) {
        Set userRoles = realmMapping.getUserRoles(authPrincipal);
        ArrayList<String> roles = new ArrayList<String>();
        if (userRoles != null) {
            for (Principal role : userRoles) {
                roles.add(role.getName());
            }
        }
        JBossGenericPrincipal gp = new JBossGenericPrincipal((Realm)this, subject, authPrincipal, callerPrincipal, credential, roles, userRoles);
        return gp;
    }

    protected String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String getPassword(String username) {
        String password = null;
        return password;
    }

    protected Principal getPrincipal(String username) {
        return new SimplePrincipal(username);
    }

    static String requestURI(Request request) {
        String uri = request.getMappingData().requestPath.getString();
        if (uri == null || uri.equals("/")) {
            uri = "";
        }
        return uri;
    }

    protected Set<Principal> getPrincipalRoles(Principal principal) {
        if (!(principal instanceof GenericPrincipal)) {
            throw new IllegalStateException("Expected GenericPrincipal, but saw: " + principal.getClass());
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        String[] roleNames = gp.getRoles();
        HashSet<Principal> userRoles = new HashSet<Principal>();
        if (roleNames != null) {
            for (int n = 0; n < roleNames.length; ++n) {
                SimplePrincipal sp = new SimplePrincipal(roleNames[n]);
                userRoles.add((Principal)sp);
            }
        }
        return userRoles;
    }

    private Subject establishSubjectContext(Principal principal) {
        Subject caller;
        block4: {
            caller = null;
            try {
                caller = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
            }
            catch (PolicyContextException e) {
                if (!this.trace) break block4;
                log.trace((Object)"Failed to get subject from PolicyContext", (Throwable)e);
            }
        }
        if (caller == null && principal instanceof JBossGenericPrincipal) {
            JBossGenericPrincipal jgp = (JBossGenericPrincipal)((Object)principal);
            caller = jgp.getSubject();
            if (this.trace) {
                log.trace((Object)"Restoring principal info from cache");
            }
            SecurityAssociationActions.setPrincipalInfo(jgp.getAuthPrincipal(), jgp.getCredentials(), jgp.getSubject());
        }
        return caller;
    }

    private javax.naming.Context getSecurityNamingContext() {
        javax.naming.Context securityCtx = null;
        InitialContext iniCtx = null;
        try {
            iniCtx = new InitialContext();
            securityCtx = (javax.naming.Context)iniCtx.lookup("java:comp/env/security");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return securityCtx;
    }

    private JBossWebMetaData getMetaData() {
        return SecurityAssociationValve.activeWebMetaData.get();
    }

    private String getSecurityDomain() {
        String securityDomain = null;
        JBossWebMetaData jbossMetaData = this.getMetaData();
        if (jbossMetaData != null) {
            securityDomain = jbossMetaData.getSecurityDomain();
        }
        if (securityDomain != null) {
            securityDomain = SecurityUtil.unprefixSecurityDomain((String)securityDomain);
        }
        return securityDomain;
    }

    private SubjectSecurityManager getSubjectSecurityManager(String wherefrom) {
        SubjectSecurityManager subjectSecurityManager = null;
        javax.naming.Context securityCtx = this.getSecurityNamingContext();
        if (securityCtx == null && this.trace) {
            log.trace((Object)("No security naming context for " + wherefrom));
        }
        try {
            if (securityCtx != null) {
                subjectSecurityManager = (SubjectSecurityManager)securityCtx.lookup("securityMgr");
            }
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (subjectSecurityManager == null && securityManagerFallback) {
            String str = "java:/jaas/" + this.getSecurityDomain();
            try {
                InitialContext ic = new InitialContext();
                subjectSecurityManager = (SubjectSecurityManager)ic.lookup(str);
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        return subjectSecurityManager;
    }

    private RealmMapping getRealmMapping() {
        RealmMapping realmMapping = null;
        javax.naming.Context securityCtx = this.getSecurityNamingContext();
        if (securityCtx == null) {
            if (this.trace) {
                log.trace((Object)"No security naming context");
            }
            return null;
        }
        try {
            realmMapping = (RealmMapping)securityCtx.lookup("realmMapping");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return realmMapping;
    }

    private SecurityConstraint[] getSecurityConstraintsFromProvider(Request request, Context context) {
        Method findsc;
        Object[] args;
        Class[] sig;
        SecurityConstraint[] scarr;
        block9: {
            scarr = null;
            sig = new Class[]{Request.class, javax.naming.Context.class};
            args = new Object[]{request, context};
            findsc = null;
            try {
                Policy policy = Policy.getPolicy();
                findsc = policy.getClass().getMethod("findSecurityConstraints", sig);
                scarr = (SecurityConstraint[])findsc.invoke((Object)policy, args);
            }
            catch (Throwable t) {
                if (!this.trace) break block9;
                log.error((Object)"Error obtaining security constraints from policy", t);
            }
        }
        if (scarr == null || scarr.length == 0) {
            if (this.securityConstraintProviderClass == "" || this.securityConstraintProviderClass.length() == 0) {
                if (this.trace) {
                    log.trace((Object)"unprotectedResourceDelegation is true but securityConstraintProviderClass is empty");
                }
            } else {
                try {
                    Class<?> clazz = SecurityAssociationActions.loadClass(this.securityConstraintProviderClass);
                    Object obj = clazz.newInstance();
                    findsc = clazz.getMethod("findSecurityConstraints", sig);
                    if (this.trace) {
                        log.trace((Object)"findSecurityConstraints method found in securityConstraintProviderClass");
                    }
                    scarr = (SecurityConstraint[])findsc.invoke(obj, args);
                }
                catch (Throwable t) {
                    log.error((Object)("Error instantiating " + this.securityConstraintProviderClass), t);
                }
            }
        }
        return scarr;
    }

    private String getServletName(Wrapper servlet) {
        String[] mappings = servlet.findMappings();
        if (this.trace) {
            log.trace((Object)("[getServletName:servletmappings=" + mappings + ":servlet.getName()=" + servlet.getName() + "]"));
        }
        if ("jsp".equals(servlet.getName()) && mappings != null && mappings[0].indexOf("*.jsp") > -1) {
            return "";
        }
        return servlet.getName();
    }

    private void audit(String level, Map<String, Object> contextMap, Exception e) {
        block5: {
            String requestInfo = "";
            try {
                HttpServletRequest hsr = (HttpServletRequest)PolicyContext.getContext((String)"javax.servlet.http.HttpServletRequest");
                requestInfo = WebUtil.deriveUsefulInfo(hsr);
                contextMap.put("request", requestInfo);
            }
            catch (PolicyContextException pe) {
                if (!this.trace) break block5;
                log.trace((Object)"Error obtaining the servlet request:", (Throwable)pe);
            }
        }
        contextMap.put("Source", ((Object)((Object)this)).getClass().getName());
        AuditEvent ae = new AuditEvent(level);
        ae.setContextMap(contextMap);
        ae.setUnderlyingException(e);
        SecurityContext sc = SecurityAssociationActions.getSecurityContext();
        if (sc != null) {
            AuditManager auditManager = sc.getAuditManager();
            if (auditManager != null) {
                auditManager.audit(ae);
            } else {
                log.trace((Object)"Audit Manager obtained from Security Context is null");
            }
        }
    }

    private void successAudit(Principal callerPrincipal, Principal principal) {
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.put("principal", principal);
        cmap.put("CallerPrincipal", callerPrincipal);
        this.audit("Success", cmap, null);
    }

    private void failureAudit(Principal principal) {
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.put("principal", principal);
        this.audit("Failure", cmap, null);
    }

    private void errorAudit(Principal principal, Exception e) {
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.put("principal", principal);
        this.audit("Error", cmap, e);
    }

    private PolicyRegistration getPolicyRegistration() {
        PolicyRegistration policyRegistration = null;
        try {
            policyRegistration = (PolicyRegistration)new InitialContext().lookup("java:/policyRegistration");
        }
        catch (Exception e) {
            log.trace((Object)"Error obtaining PolicyRegistration", (Throwable)e);
        }
        return policyRegistration;
    }

    static {
        String str = SecurityAssociationActions.getSystemProperty("jbosswebrealm.fallback", "false");
        securityManagerFallback = Boolean.parseBoolean(str);
    }
}

