/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.PrivilegedActionException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.SecurityUtil;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

public class SecurityContextEstablishmentValve
extends ValveBase {
    private String configuredSecurityDomainName;
    private String securityContextClassName;
    private ISecurityManagement securityManagement;

    public SecurityContextEstablishmentValve(String configuredSecurityDomain, String defaultSecurityDomain, String fqnClass, ISecurityManagement securityManagement) {
        String securityDomain = defaultSecurityDomain;
        if (configuredSecurityDomain != null) {
            securityDomain = configuredSecurityDomain;
        }
        this.configuredSecurityDomainName = SecurityUtil.unprefixSecurityDomain((String)securityDomain);
        this.securityContextClassName = fqnClass;
        this.securityManagement = securityManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        SecurityContext cachedContext = null;
        boolean createdSecurityContext = false;
        SecurityContext sc = SecurityAssociationActions.getSecurityContext();
        if (sc != null && !sc.getSecurityDomain().equals(this.configuredSecurityDomainName)) {
            cachedContext = sc;
            SecurityContext newSC = this.createSecurityContext();
            SecurityAssociationActions.setSecurityContext(newSC);
            createdSecurityContext = true;
        }
        if (sc == null) {
            sc = this.createSecurityContext();
            SecurityAssociationActions.setSecurityContext(sc);
            createdSecurityContext = true;
        }
        try {
            this.getNext().invoke(request, response);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            SecurityRolesAssociation.setSecurityRoles(null);
            if (createdSecurityContext) {
                SecurityAssociationActions.clearSecurityContext();
            }
            if (cachedContext != null) {
                SecurityAssociationActions.setSecurityContext(cachedContext);
            }
            throw throwable;
        }
        SecurityRolesAssociation.setSecurityRoles(null);
        if (createdSecurityContext) {
            SecurityAssociationActions.clearSecurityContext();
        }
        if (cachedContext != null) {
            SecurityAssociationActions.setSecurityContext(cachedContext);
        }
    }

    private SecurityContext createSecurityContext() {
        SecurityContext securityContext = null;
        try {
            securityContext = SecurityAssociationActions.createSecurityContext(this.configuredSecurityDomainName, this.securityContextClassName);
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        securityContext.setSecurityManagement(this.securityManagement);
        return securityContext;
    }
}

