/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.catalina.Session;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.SnapshotManager;

public class IntervalSnapshotManager
extends SnapshotManager
implements Runnable {
    static Logger log = Logger.getLogger(IntervalSnapshotManager.class);
    private int interval = 1000;
    private Set sessions = new LinkedHashSet();
    private Thread thread = null;
    private boolean processingAllowed = false;
    private boolean threadDone = false;

    public IntervalSnapshotManager(AbstractJBossManager manager, String path) {
        super(manager, path);
    }

    public IntervalSnapshotManager(AbstractJBossManager manager, String path, int interval) {
        super(manager, path);
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot(ClusteredSession session) {
        try {
            Set set = this.sessions;
            synchronized (set) {
                this.sessions.add(session);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to queue session " + (Object)((Object)session) + " for replication"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSessions() {
        ClusteredSession[] toProcess = null;
        Set set = this.sessions;
        synchronized (set) {
            toProcess = new ClusteredSession[this.sessions.size()];
            toProcess = this.sessions.toArray(toProcess);
            this.sessions.clear();
        }
        AbstractJBossManager mgr = this.getManager();
        for (int i = 0; i < toProcess.length && this.processingAllowed; ++i) {
            try {
                mgr.storeSession((Session)toProcess[i]);
                continue;
            }
            catch (Exception e) {
                this.getLog().error((Object)("Caught exception processing session " + toProcess[i].getRealId()), (Throwable)e);
            }
        }
    }

    public void start() {
        this.processingAllowed = true;
        this.startThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.processingAllowed = false;
        this.stopThread();
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.clear();
        }
    }

    protected void startThread() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "ClusteredSessionDistributor[" + this.getContextPath() + "]");
        this.thread.setDaemon(true);
        this.thread.setContextClassLoader(this.getManager().getContainer().getLoader().getClassLoader());
        this.threadDone = false;
        this.thread.start();
    }

    protected void stopThread() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thread = null;
    }

    public void run() {
        while (!this.threadDone) {
            try {
                Thread.sleep(this.interval);
                this.processSessions();
            }
            catch (InterruptedException ie) {
                if (this.threadDone) continue;
                this.getLog().error((Object)"Caught exception processing sessions", (Throwable)ie);
            }
            catch (Exception e) {
                this.getLog().error((Object)"Caught exception processing sessions", (Throwable)e);
            }
        }
    }
}

