/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Manager;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.metadata.web.jboss.ReplicationGranularity;
import org.jboss.metadata.web.jboss.ReplicationTrigger;
import org.jboss.metadata.web.jboss.SnapshotMode;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.web.tomcat.service.session.JBossCacheClusterMBean;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactory;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManagerFactoryFactory;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TomcatClusterConfig;
import org.jboss.web.tomcat.service.session.distributedcache.spi.TomcatClusterDistributedCacheManagerFactory;

public class JBossCacheCluster
implements TomcatClusterConfig,
JBossCacheClusterMBean,
Lifecycle {
    protected static final String info = "JBossCacheCluster/2.1";
    public static Log log = LogFactory.getLog(JBossCacheCluster.class);
    public static final String DEFAULT_CACHE_CONFIG_PATH = "conf/cluster-cache.xml";
    private Container container = null;
    private MBeanServer mserver = null;
    private ObjectName objectName = null;
    private TomcatClusterDistributedCacheManagerFactory factory = null;
    private boolean started = false;
    private LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private String pojoCacheObjectName = "jboss.cache:service=TomcatClusteringCache";
    private String clusterName = null;
    private String cacheConfigPath = null;
    private String managerClassName = JBossCacheManager.class.getName();
    private boolean useJK = false;
    private boolean useLocalCache = false;
    private ReplicationTrigger defaultReplicationTrigger = null;
    private ReplicationGranularity defaultReplicationGranularity = null;
    private SnapshotMode snapshotMode = null;
    private int snapshotInterval = 0;
    private boolean replicationFieldBatchMode = true;

    public String getCacheObjectName() {
        return this.pojoCacheObjectName;
    }

    public void setCacheObjectName(String objectName) {
        this.pojoCacheObjectName = objectName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getCacheConfigPath() {
        return this.cacheConfigPath;
    }

    public void setCacheConfigPath(String cacheConfigPath) {
        this.cacheConfigPath = cacheConfigPath;
    }

    public MBeanServer getMBeanServer() {
        if (this.mserver == null) {
            this.mserver = Registry.getRegistry(null, null).getMBeanServer();
        }
        return this.mserver;
    }

    public String getManagerClassName() {
        return this.managerClassName;
    }

    public void setManagerClassName(String managerClassName) {
        this.managerClassName = managerClassName;
    }

    public void registerManager(Manager arg0) {
    }

    public void removeManager(Manager arg0) {
    }

    public boolean isUseJK() {
        return this.useJK;
    }

    public void setUseJK(boolean useJK) {
        this.useJK = useJK;
    }

    public boolean isUseLocalCache() {
        return this.useLocalCache;
    }

    public void setUseLocalCache(boolean useLocalCache) {
        this.useLocalCache = useLocalCache;
    }

    public String getDefaultReplicationGranularity() {
        return this.defaultReplicationGranularity == null ? null : this.defaultReplicationGranularity.toString();
    }

    public void setDefaultReplicationGranularity(String defaultReplicationGranularity) {
        this.defaultReplicationGranularity = defaultReplicationGranularity == null ? null : ReplicationGranularity.fromString((String)defaultReplicationGranularity.toUpperCase());
    }

    public String getDefaultReplicationTrigger() {
        return this.defaultReplicationTrigger == null ? null : this.defaultReplicationTrigger.toString();
    }

    public void setDefaultReplicationTrigger(String defaultTrigger) {
        this.defaultReplicationTrigger = defaultTrigger == null ? null : ReplicationTrigger.fromString((String)defaultTrigger.toUpperCase());
    }

    public boolean getDefaultReplicationFieldBatchMode() {
        return this.replicationFieldBatchMode;
    }

    public void setDefaultReplicationFieldBatchMode(boolean replicationFieldBatchMode) {
        this.replicationFieldBatchMode = replicationFieldBatchMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode == null ? null : this.snapshotMode.toString();
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode == null ? null : SnapshotMode.fromString((String)snapshotMode.toUpperCase());
    }

    public int getSnapshotInterval() {
        return this.snapshotInterval;
    }

    public void setSnapshotInterval(int snapshotInterval) {
        this.snapshotInterval = snapshotInterval;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public String getInfo() {
        return info;
    }

    public Manager createManager(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating ClusterManager for context " + name + " using class " + this.getManagerClassName()));
        }
        JBossCacheManager manager = null;
        String mgrClass = this.getManagerClassName();
        if (mgrClass != null && !JBossCacheManager.class.getName().equals(mgrClass)) {
            try {
                manager = (Manager)this.getClass().getClassLoader().loadClass(mgrClass).newInstance();
            }
            catch (Exception x) {
                log.error((Object)("Unable to load class " + mgrClass + " for replication manager; using JBossCacheManager"), (Throwable)x);
            }
        }
        if (manager == null) {
            if (this.factory == null) {
                throw new IllegalStateException("PojoCache not initialized");
            }
            manager = new JBossCacheManager((DistributedCacheManagerFactory)this.factory);
        }
        manager.setDistributable(true);
        if (manager instanceof JBossCacheManager) {
            this.configureManager(manager);
        }
        return manager;
    }

    public void backgroundProcess() {
    }

    public String getProtocol() {
        return null;
    }

    public void setProtocol(String protocol) {
    }

    public void startContext(String contextPath) throws IOException {
    }

    public void installContext(String contextPath, URL war) {
    }

    public void stop(String contextPath) throws IOException {
    }

    public void configureManager(JBossCacheManager manager) {
        manager.setSnapshotMode(this.snapshotMode);
        manager.setSnapshotInterval(this.snapshotInterval);
        manager.setUseJK(this.useJK);
        if (manager.getReplicationGranularity() == null) {
            manager.setReplicationGranularity(this.defaultReplicationGranularity);
        }
        if (manager.getReplicationTrigger() == null) {
            manager.setReplicationTrigger(this.defaultReplicationTrigger);
        }
        if (manager.isReplicationFieldBatchMode() == null) {
            manager.setReplicationFieldBatchMode(this.replicationFieldBatchMode);
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("Cluster already started");
        }
        this.lifecycle.fireLifecycleEvent("before_start", (Object)this);
        try {
            try {
                MBeanServerLocator.locateJBoss();
            }
            catch (IllegalStateException ise) {
                MBeanServerLocator.setJBoss((MBeanServer)this.getMBeanServer());
            }
            this.factory = DistributedCacheManagerFactoryFactory.getInstance().getTomcatClusterDistributedCacheManagerFactory((TomcatClusterConfig)this);
            this.registerMBeans();
            this.factory.start();
            this.started = true;
            this.lifecycle.fireLifecycleEvent("after_start", (Object)this);
        }
        catch (LifecycleException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"Unable to start cluster.", (Throwable)e);
            throw new LifecycleException((Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new IllegalStateException("Cluster not started");
        }
        this.lifecycle.fireLifecycleEvent("before_stop", (Object)this);
        try {
            this.factory.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Failed to stop DistributedCacheManagerFactory", (Throwable)e);
        }
        this.started = false;
        this.lifecycle.fireLifecycleEvent("after_stop", (Object)this);
        this.unregisterMBeans();
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public File getCacheConfigFile() throws FileNotFoundException {
        boolean useDefault = this.cacheConfigPath == null;
        String path = useDefault ? DEFAULT_CACHE_CONFIG_PATH : this.cacheConfigPath;
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), path);
        }
        if (file.exists()) {
            return file;
        }
        String msg = "No tree cache config file found at " + file.getAbsolutePath();
        log.error((Object)msg);
        throw new IllegalStateException(msg);
    }

    private void registerMBeans() {
        try {
            MBeanServer server = this.getMBeanServer();
            String domain = this.container instanceof ContainerBase ? ((ContainerBase)this.container).getDomain() : server.getDefaultDomain();
            String name = ":type=Cluster";
            if (this.container instanceof Host) {
                name = name + ",host=" + this.container.getName();
            } else if (this.container instanceof Engine) {
                name = name + ",engine=" + this.container.getName();
            }
            ObjectName clusterName = new ObjectName(domain + name);
            if (server.isRegistered(clusterName)) {
                log.warn((Object)("MBean " + clusterName + " already registered"));
            } else {
                this.objectName = clusterName;
                server.registerMBean(this, this.objectName);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void unregisterMBeans() {
        if (this.mserver != null) {
            try {
                if (this.objectName != null) {
                    this.mserver.unregisterMBean(this.objectName);
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
    }
}

