/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.JBossCacheManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributableSession;
import org.jboss.web.tomcat.service.session.distributedcache.spi.DistributedCacheManager;

public abstract class JBossCacheClusteredSession
extends ClusteredSession
implements DistributableSession {
    protected transient DistributedCacheManager proxy_;

    public JBossCacheClusteredSession(JBossCacheManager manager) {
        super(manager, manager.getReplicationTrigger(), manager.getUseJK());
        int maxUnrep = manager.getMaxUnreplicatedInterval() * 1000;
        this.setMaxUnreplicatedInterval(maxUnrep);
        this.establishProxy();
    }

    public void initAfterLoad(AbstractJBossManager manager) {
        this.setManager(manager);
        this.establishProxy();
        this.populateAttributes();
        this.activate();
        this.clearOutdated();
    }

    public boolean needRegionForSession() {
        return false;
    }

    public boolean hasRegionForSession() {
        return false;
    }

    public void createdRegionForSession() {
    }

    protected void establishProxy() {
        if (this.proxy_ == null) {
            this.proxy_ = ((JBossCacheManager)this.manager).getDistributedCacheManager();
            if (this.proxy_ == null) {
                throw new RuntimeException("JBossCacheClusteredSession: Cache service is null.");
            }
        }
    }

    protected abstract void populateAttributes();

    public void recycle() {
        super.recycle();
        this.proxy_ = null;
    }

    public synchronized void processSessionRepl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("processSessionRepl(): session is dirty. Will increment version from: " + this.getVersion() + " and replicate."));
        }
        this.incrementVersionFromLocalActivity();
        this.proxy_.putSession(this.realId, (DistributableSession)this);
        this.replicateAttributes();
        this.sessionAttributesDirty = false;
        this.sessionMetadataDirty = false;
        this.updateLastReplicated();
    }

    protected void replicateAttributes() {
    }

    protected void removeFromManager(boolean localCall, boolean localOnly) {
        if (localCall) {
            super.removeFromManager(localCall, localOnly);
        }
    }

    protected Object removeAttributeInternal(String name, boolean localCall, boolean localOnly) {
        return this.removeJBossInternalAttribute(name, localCall, localOnly);
    }
}

