/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.web.metamodel.descriptor;

import org.jboss.logging.Logger;

/**
 * Represents a <replication-config> element of the jboss-web.xml deployment descriptor 
 *
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 * @version <tt>$Revision: 65351 $</tt>
 */
public class ReplicationConfig
{
   private static final Logger log = Logger.getLogger(ReplicationConfig.class);

   protected String trigger;
   protected String granularity;
   protected String fieldBatchMode;
   protected String defaultCacheName;
   protected String cacheName;
   protected String useJK;
   protected String snapshotMode;
   protected String snapshotInterval;
   protected String useLocalCache;
   
   public String getTrigger()
   {
      return trigger;
   }
   
   public void setTrigger(String trigger)
   {
      this.trigger = trigger;
   }
   
   public String getGranularity()
   {
      return granularity;
   }
   
   public void setGranularity(String granularity)
   {
      this.granularity = granularity;
   }
   
   public String getFieldBatchMode()
   {
      return fieldBatchMode;
   }
   
   public void setFieldBatchMode(String fieldBatchMode)
   {
      this.fieldBatchMode = fieldBatchMode;
   }

   public String getCacheName()
   {
      return cacheName;
   }

   public void setCacheName(String cacheName)
   {
      this.cacheName = cacheName;
   }

   public String getDefaultCacheName()
   {
      return defaultCacheName;
   }

   public void setDefaultCacheName(String defaultCacheName)
   {
      this.defaultCacheName = defaultCacheName;
   }

   public String getSnapshotInterval()
   {
      return snapshotInterval;
   }

   public void setSnapshotInterval(String snapshotInterval)
   {
      this.snapshotInterval = snapshotInterval;
   }

   public String getSnapshotMode()
   {
      return snapshotMode;
   }

   public void setSnapshotMode(String snapshotMode)
   {
      this.snapshotMode = snapshotMode;
   }

   public String getUseJK()
   {
      return useJK;
   }

   public void setUseJK(String useJK)
   {
      this.useJK = useJK;
   }

   public String getUseLocalCache()
   {
      return useLocalCache;
   }

   public void setUseLocalCache(String useLocalCache)
   {
      this.useLocalCache = useLocalCache;
   }
   
   public void setDefaultSnapshotMode(String mode)
   {
      if (isEmpty(snapshotMode))
      {
         snapshotMode = mode;
      }
   }
   
   public void setDefaultSnapshotInterval(int interval)
   {
      if (isEmpty(snapshotInterval))
      {
         snapshotInterval = String.valueOf(interval);
      }
   }
   
   public void setDefaultUseJK(boolean useJK)
   {
      if (isEmpty(this.useJK))
      {
         this.useJK = String.valueOf(useJK);
      }
   }
   
   public void setDefaultUseLocalCache(boolean useLocal)
   {
      if (isEmpty(this.useLocalCache))
      {
         this.useLocalCache = String.valueOf(useLocal);
      }
   }

   public String toString()
   {
      StringBuffer sb = new StringBuffer(100);
      sb.append("cacheName=").append(cacheName)
        .append(";defaultCacheName=").append(defaultCacheName)
        .append(";granularity=").append(granularity)
        .append(";trigger=").append(trigger)
        .append(";fieldBatchMode=").append(fieldBatchMode)
        .append(";useJK=").append(useJK)
        .append(";snapshotMode=").append(snapshotMode)
        .append(";snapshotInterval=").append(snapshotInterval)
        .append(";useLocalCache=").append(useLocalCache);
      return sb.toString();
   }
   
   private static boolean isEmpty(String str)
   {
      return str == null || str.trim().length() == 0;
   }
}
