/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.injection;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.ejb.EJBException;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import javax.xml.ws.WebServiceContext;
import org.jboss.ejb3.Container;
import org.jboss.injection.EnvEntryEncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.injection.InjectionHandler;
import org.jboss.injection.InjectionUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.InjectorFactory;
import org.jboss.injection.JndiPropertyInjector;
import org.jboss.injection.LinkRefEncInjector;
import org.jboss.injection.TimerServicePropertyInjector;
import org.jboss.injection.UserTransactionPropertyInjector;
import org.jboss.injection.ValueEncInjector;
import org.jboss.injection.lang.reflect.BeanProperty;
import org.jboss.injection.lang.reflect.FieldBeanProperty;
import org.jboss.injection.lang.reflect.MethodBeanProperty;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.reflect.plugins.ValueConvertor;
import org.jboss.web.tomcat.service.injection.TomcatInjectionUtils;
import org.jboss.web.tomcat.service.injection.WebServiceContextPropertyInjector;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebResourceHandler<X extends RemoteEnvironment>
implements InjectionHandler<X> {
    private static final Logger log = Logger.getLogger(WebResourceHandler.class);
    private boolean checkEncInjectors;

    public WebResourceHandler() {
        this(true);
    }

    public WebResourceHandler(boolean checkEncInjectors) {
        this.checkEncInjectors = checkEncInjectors;
    }

    private static void createURLInjector(String encName, String mappedName, InjectionContainer container) {
        assert (encName.length() > 0) : "encName is empty";
        assert (mappedName.length() > 0) : "mappedName is empty";
        try {
            URL url = new URL(mappedName.trim());
            container.getEncInjectors().put(encName, new ValueEncInjector(encName, (Object)url, "@Resource"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("failed to create url injector for: " + encName, e);
        }
    }

    private static void loadEnvEntry(InjectionContainer container, Collection<EnvironmentEntryMetaData> envEntries) {
        for (EnvironmentEntryMetaData envEntry : envEntries) {
            String encName = "env/" + envEntry.getEnvEntryName();
            if (envEntry.getValue() == null) {
                log.debug((Object)("ignoring env-entry " + envEntry));
                continue;
            }
            InjectionUtil.injectionTarget((String)encName, (ResourceInjectionMetaData)envEntry, (InjectionContainer)container, (Map)container.getEncInjections());
            if (container.getEncInjectors().containsKey(encName)) continue;
            log.trace((Object)("adding env-entry injector " + encName));
            container.getEncInjectors().put(encName, new EnvEntryEncInjector(encName, envEntry.getType(), envEntry.getValue()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadXmlResourceRefs(InjectionContainer container, Collection<ResourceReferenceMetaData> refs) {
        for (ResourceReferenceMetaData envRef : refs) {
            String encName = "env/" + envRef.getResourceRefName();
            if (container.getEncInjectors().containsKey(encName)) continue;
            String mappedName = envRef.getMappedName();
            if (mappedName == null || mappedName.length() == 0) {
                mappedName = envRef.getResolvedJndiName();
            }
            if (mappedName == null || mappedName.length() == 0) {
                if (envRef.getResUrl() != null) {
                    try {
                        container.getEncInjectors().put(encName, new ValueEncInjector(encName, (Object)new URL(envRef.getResUrl().trim()), "<resource-ref>"));
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                } else if (UserTransaction.class.getName().equals(envRef.getType())) {
                    final InjectionContainer ic = container;
                    InjectorFactory<UserTransactionPropertyInjector> factory = new InjectorFactory<UserTransactionPropertyInjector>(){

                        public UserTransactionPropertyInjector create(BeanProperty property) {
                            return new UserTransactionPropertyInjector(property, ic);
                        }
                    };
                    if (envRef.getInjectionTargets() != null) {
                        TomcatInjectionUtils.createInjectors(container.getEncInjections(), container.getClassloader(), factory, envRef.getInjectionTargets());
                        continue;
                    }
                    encName = "java:comp/UserTransaction";
                } else {
                    if (!ORB.class.getName().equals(envRef.getType())) throw new RuntimeException("mapped-name is required for " + envRef.getResourceRefName() + " of deployment " + container.getIdentifier());
                    encName = "java:comp/ORB";
                }
            } else {
                if (URL.class.getName().equals(envRef.getType()) && !mappedName.startsWith("java:")) {
                    WebResourceHandler.createURLInjector(encName, mappedName, container);
                    InjectionUtil.injectionTarget((String)encName, (ResourceInjectionMetaData)envRef, (InjectionContainer)container, (Map)container.getEncInjections());
                    continue;
                }
                if (envRef.getResUrl() != null) {
                    try {
                        container.getEncInjectors().put(encName, new ValueEncInjector(encName, (Object)new URL(envRef.getResUrl().trim()), "<resource-ref>"));
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, mappedName, "<resource-ref>"));
                }
            }
            InjectionUtil.injectionTarget((String)encName, (ResourceInjectionMetaData)envRef, (InjectionContainer)container, (Map)container.getEncInjections());
        }
    }

    private static void loadXmlResourceEnvRefs(InjectionContainer container, Collection<ResourceEnvironmentReferenceMetaData> refs) {
        for (ResourceEnvironmentReferenceMetaData envRef : refs) {
            String resTypeName = envRef.getType();
            String mappedName = envRef.getMappedName();
            if (mappedName == null || mappedName.length() == 0) {
                mappedName = envRef.getResolvedJndiName();
            }
            try {
                if (resTypeName != null) {
                    Class<?> resType = Class.forName(resTypeName);
                    if (TimerService.class.isAssignableFrom(resType)) {
                        log.warn((Object)"Ignoring invalid TimerService resource-env-ref");
                        continue;
                    }
                    if (SessionContext.class.isAssignableFrom(resType)) {
                        log.warn((Object)"Ignoring invalid SessionContext resource-env-ref");
                        continue;
                    }
                    if (resType.equals(UserTransaction.class)) {
                        final InjectionContainer ic = container;
                        InjectorFactory<UserTransactionPropertyInjector> factory = new InjectorFactory<UserTransactionPropertyInjector>(){

                            public UserTransactionPropertyInjector create(BeanProperty property) {
                                return new UserTransactionPropertyInjector(property, ic);
                            }
                        };
                        if (envRef.getInjectionTargets() != null) {
                            TomcatInjectionUtils.createInjectors(container.getEncInjections(), container.getClassloader(), factory, envRef.getInjectionTargets());
                            continue;
                        }
                        mappedName = "java:comp/UserTransaction";
                    } else {
                        if (resType.equals(ORB.class)) {
                            mappedName = "java:comp/ORB";
                            continue;
                        }
                        if (WebServiceContext.class.getName().equals(envRef.getType())) {
                            InjectorFactory<WebServiceContextPropertyInjector> factory = new InjectorFactory<WebServiceContextPropertyInjector>(){

                                public WebServiceContextPropertyInjector create(BeanProperty property) {
                                    return new WebServiceContextPropertyInjector(property);
                                }
                            };
                            if (envRef.getInjectionTargets() != null) {
                                TomcatInjectionUtils.createInjectors(container.getEncInjections(), container.getClassloader(), factory, envRef.getInjectionTargets());
                                continue;
                            }
                        }
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new EJBException((Exception)e);
            }
            String encName = "env/" + envRef.getResourceEnvRefName();
            if (container.getEncInjectors().containsKey(encName)) continue;
            if (mappedName == null || mappedName.equals("")) {
                throw new RuntimeException("mapped-name is required for " + envRef.getResourceEnvRefName() + " of deployment " + container.getIdentifier());
            }
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, envRef.getMappedName(), "<resource-ref>"));
            InjectionUtil.injectionTarget((String)encName, (ResourceInjectionMetaData)envRef, (InjectionContainer)container, (Map)container.getEncInjections());
        }
    }

    private static void loadXmlMessageDestinationRefs(InjectionContainer container, Collection<MessageDestinationReferenceMetaData> refs) {
        for (MessageDestinationReferenceMetaData envRef : refs) {
            String encName = "env/" + envRef.getMessageDestinationRefName();
            if (container.getEncInjectors().containsKey(encName)) continue;
            String jndiName = envRef.getMappedName();
            if ((jndiName == null || jndiName.equals("")) && ((jndiName = envRef.getResolvedJndiName()) == null || jndiName.equals(""))) {
                throw new RuntimeException("mapped-name is required for " + envRef.getMessageDestinationRefName() + " of deployment " + container.getIdentifier());
            }
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, jndiName, "<message-destination-ref>"));
            InjectionUtil.injectionTarget((String)encName, (ResourceInjectionMetaData)envRef, (InjectionContainer)container, (Map)container.getEncInjections());
        }
    }

    public void loadXml(X xml, InjectionContainer container) {
        if (xml == null) {
            return;
        }
        if (xml.getMessageDestinationReferences() != null) {
            WebResourceHandler.loadXmlMessageDestinationRefs(container, (Collection<MessageDestinationReferenceMetaData>)xml.getMessageDestinationReferences());
        }
        if (xml.getResourceEnvironmentReferences() != null) {
            WebResourceHandler.loadXmlResourceEnvRefs(container, (Collection<ResourceEnvironmentReferenceMetaData>)xml.getResourceEnvironmentReferences());
        }
        if (xml.getResourceReferences() != null) {
            WebResourceHandler.loadXmlResourceRefs(container, (Collection<ResourceReferenceMetaData>)xml.getResourceReferences());
        }
        if (xml.getEnvironmentEntries() != null) {
            WebResourceHandler.loadEnvEntry(container, (Collection<EnvironmentEntryMetaData>)xml.getEnvironmentEntries());
        }
    }

    public void handleClassAnnotations(Class<?> clazz, InjectionContainer container) {
        Resource res;
        Resources resources = (Resources)container.getAnnotation(Resources.class, clazz);
        if (resources != null) {
            for (Resource ref : resources.value()) {
                this.handleClassAnnotation(ref, container, clazz);
            }
        }
        if ((res = (Resource)container.getAnnotation(Resource.class, clazz)) != null) {
            this.handleClassAnnotation(res, container, clazz);
        }
    }

    private void handleClassAnnotation(Resource ref, InjectionContainer container, Class<?> clazz) {
        String encName = ref.name();
        if (encName == null || encName.equals("")) {
            throw new RuntimeException("JBoss requires name() for class level @Resource");
        }
        encName = "env/" + ref.name();
        if (container.getEncInjectors().containsKey(encName)) {
            return;
        }
        String mappedName = ref.mappedName();
        if (mappedName == null || mappedName.equals("")) {
            if (ORB.class.isAssignableFrom(ref.type())) {
                mappedName = "java:comp/ORB";
            } else if (UserTransaction.class.isAssignableFrom(ref.type())) {
                mappedName = "java:comp/UserTransaction";
            } else {
                throw new RuntimeException("You did not specify a @Resource.mappedName() for name: " + ref.name() + ", class: " + clazz.getName() + " and there is no binding for that enc name in XML");
            }
        }
        if (ref.type() == URL.class) {
            WebResourceHandler.createURLInjector(encName, mappedName, container);
        } else {
            container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, ref.mappedName(), "@Resource"));
        }
    }

    public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        Resource ref = (Resource)container.getAnnotation(Resource.class, method);
        if (ref == null) {
            return;
        }
        log.trace((Object)("method " + method + " has @Resource"));
        this.handlePropertyAnnotation(ref, (BeanProperty)new MethodBeanProperty(method), container, injectors);
    }

    public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        Resource ref = (Resource)container.getAnnotation(Resource.class, field);
        if (ref == null) {
            return;
        }
        log.trace((Object)("field " + field + " has @Resource"));
        this.handlePropertyAnnotation(ref, (BeanProperty)new FieldBeanProperty(field), container, injectors);
    }

    private void handlePropertyAnnotation(Resource ref, BeanProperty property, InjectionContainer container, Map<AccessibleObject, Injector> injectors) {
        assert (ref != null);
        assert (property != null);
        assert (container != null);
        assert (injectors != null);
        String encName = ref.name();
        if (encName == null || encName.equals("")) {
            encName = property.getDeclaringClass().getName() + "/" + property.getName();
        }
        if (!encName.startsWith("env/")) {
            encName = "env/" + encName;
        }
        AccessibleObject accObj = property.getAccessibleObject();
        Class type = property.getType();
        if (!ref.type().equals(Object.class)) {
            type = ref.type();
        }
        if (type.equals(UserTransaction.class)) {
            injectors.put(accObj, (Injector)new UserTransactionPropertyInjector(property, container));
        } else if (type.equals(TimerService.class)) {
            injectors.put(accObj, (Injector)new TimerServicePropertyInjector(property, (Container)container));
        } else if (type.equals(URL.class) && ref.mappedName() != null && ref.mappedName().length() > 0) {
            WebResourceHandler.createURLInjector(encName, ref.mappedName(), container);
            injectors.put(accObj, (Injector)new JndiPropertyInjector(property, encName, container.getEnc()));
        } else if (type.equals(String.class) || type.equals(Character.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Boolean.class) || type.equals(Double.class) || type.equals(Float.class) || type.isPrimitive()) {
            if (container.getEncInjectors().containsKey(encName)) {
                injectors.put(accObj, (Injector)new JndiPropertyInjector(property, encName, container.getEnc()));
            } else if (ref.mappedName() != null && ref.mappedName().length() > 0) {
                String s = ref.mappedName().trim();
                try {
                    Object value = ValueConvertor.convertValue((Class)type, (Object)s);
                    container.getEncInjectors().put(encName, new ValueEncInjector(encName, value, "@Resource"));
                    injectors.put(accObj, (Injector)new JndiPropertyInjector(property, encName, container.getEnc()));
                }
                catch (Throwable t) {
                    throw new RuntimeException("Failed to convert: " + ref.mappedName() + " to type:" + type, t);
                }
            } else {
                log.warn((Object)("Not injecting " + property.getName() + ", no matching enc injector " + encName + " found"));
            }
        } else {
            if (this.checkEncInjectors && !container.getEncInjectors().containsKey(encName)) {
                String mappedName = ref.mappedName();
                if (mappedName == null || mappedName.equals("")) {
                    if (ORB.class.isAssignableFrom(type)) {
                        mappedName = "java:comp/ORB";
                    } else {
                        throw new RuntimeException("You did not specify a @Resource.mappedName() on " + accObj + " and there is no binding for enc name " + encName + " in XML");
                    }
                }
                container.getEncInjectors().put(encName, new LinkRefEncInjector(encName, mappedName, "@Resource"));
            }
            injectors.put(accObj, (Injector)new JndiPropertyInjector(property, encName, container.getEnc()));
        }
    }
}

