/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.config;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletsLoggers {
    private FaceletsLoggers() {
    }

    public static boolean isFaceletsAvailable() {
        try {
            FaceletsLoggers.classForName("com.sun.facelets.Facelet");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Iterator<Logger> getLoggers() throws Exception {
        ArrayList<Logger> loggers = new ArrayList<Logger>();
        if (!FaceletsLoggers.isFaceletsAvailable()) {
            return loggers.iterator();
        }
        loggers.add(FaceletsLoggers.getPrivateStaticLogger("com.sun.facelets.compiler.TagLibraryConfig", "log"));
        loggers.add(FaceletsLoggers.getPrivateStaticLogger("com.sun.facelets.compiler.Compiler", "log"));
        loggers.add(FaceletsLoggers.getPrivateStaticLogger("com.sun.facelets.impl.DefaultFaceletFactory", "log"));
        loggers.add(FaceletsLoggers.getPrivateStaticLogger("com.sun.facelets.tag.jsf.ComponentHandler", "log"));
        loggers.add(FaceletsLoggers.getPrivateStaticLogger("com.sun.facelets.util.Resource", "log"));
        loggers.add(FaceletsLoggers.getPrivateStaticLogger("com.sun.facelets.FaceletViewHandler", "log"));
        loggers.add(FaceletsLoggers.getPrivateStaticLogger("com.sun.facelets.compiler.CompilationManager", "log"));
        loggers.add(FaceletsLoggers.getPrivateStaticLogger("com.sun.facelets.tag.jsf.ComponentRule", "log"));
        loggers.add(FaceletsLoggers.getPrivateStaticLogger("com.sun.facelets.tag.MetaRulesetImpl", "log"));
        return loggers.iterator();
    }

    private static Logger getPrivateStaticLogger(Class clazz, String fieldName) throws Exception {
        Field field = FaceletsLoggers.getField(clazz, fieldName);
        field.setAccessible(true);
        return (Logger)FaceletsLoggers.get(field, new Object());
    }

    private static Logger getPrivateStaticLogger(String className, String fieldName) throws Exception {
        return FaceletsLoggers.getPrivateStaticLogger(FaceletsLoggers.classForName(className), fieldName);
    }

    private static Object get(Field field, Object target) throws Exception {
        try {
            return field.get(target);
        }
        catch (IllegalArgumentException iae) {
            String message = "Could not get field value by reflection: " + FaceletsLoggers.toString(field) + " on: " + target.getClass().getName();
            throw new IllegalArgumentException(message, iae);
        }
    }

    private static Field getField(Class clazz, String name) {
        for (Class superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        throw new IllegalArgumentException("no such field: " + clazz.getName() + '.' + name);
    }

    private static Class classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    private static String toString(Member member) {
        return FaceletsLoggers.unqualify(member.getDeclaringClass().getName()) + '.' + member.getName();
    }

    private static String unqualify(String name) {
        return FaceletsLoggers.unqualify(name, '.');
    }

    private static String unqualify(String name, char sep) {
        return name.substring(name.lastIndexOf(sep) + 1, name.length());
    }
}

