/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.jsf.integration.injection;

import com.sun.faces.spi.InjectionProvider;
import com.sun.faces.spi.InjectionProviderException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.tomcat.InstanceManager;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.TomcatInjectionContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossScanningInjectionProvider
implements InjectionProvider {
    protected TomcatInjectionContainer injectionContainer = null;
    private static final Logger log = Logger.getLogger(InjectionProvider.class);

    public JBossScanningInjectionProvider() {
        Object context = FacesContext.getCurrentInstance().getExternalContext().getContext();
        if (context != null && context instanceof ServletContext) {
            ServletContext servletContext = (ServletContext)context;
            this.injectionContainer = (TomcatInjectionContainer)((Object)servletContext.getAttribute(InstanceManager.class.getName()));
        }
        if (this.injectionContainer == null) {
            log.debug((Object)"JSF injection not available for this web deployment.");
        }
    }

    protected JBossScanningInjectionProvider(TomcatInjectionContainer injectionContainer) {
        this.injectionContainer = injectionContainer;
        if (injectionContainer == null) {
            log.debug((Object)"JSF injection not available for this web deployment.");
        }
    }

    public void invokePostConstruct(Object managedBean) throws InjectionProviderException {
        try {
            Method postConstruct = this.getLifeCycleMethod(managedBean, PostConstruct.class);
            if (postConstruct != null) {
                boolean accessibility = postConstruct.isAccessible();
                postConstruct.setAccessible(true);
                postConstruct.invoke(managedBean, new Object[0]);
                postConstruct.setAccessible(accessibility);
            }
        }
        catch (Exception e) {
            throw new InjectionProviderException("PostConstruct failed on managed bean.", (Throwable)e);
        }
    }

    public void invokePreDestroy(Object managedBean) throws InjectionProviderException {
        try {
            Method preDestroy = this.getLifeCycleMethod(managedBean, PreDestroy.class);
            if (preDestroy != null) {
                boolean accessibility = preDestroy.isAccessible();
                preDestroy.setAccessible(true);
                preDestroy.invoke(managedBean, new Object[0]);
                preDestroy.setAccessible(accessibility);
            }
        }
        catch (Exception e) {
            throw new InjectionProviderException("PreDestroy failed on managed bean.", (Throwable)e);
        }
    }

    public void inject(Object managedBean) throws InjectionProviderException {
        if (!this.checkInjectionContainer()) {
            return;
        }
        try {
            this.injectionContainer.processAnnotations(managedBean);
            this.injectionContainer.processInjectors(managedBean);
        }
        catch (Exception e) {
            throw new InjectionProviderException("Injection failed on managed bean.", (Throwable)e);
        }
    }

    private Method getLifeCycleMethod(Object managedBean, Class<? extends Annotation> annotation) {
        Method[] methods = managedBean.getClass().getDeclaredMethods();
        Method lifeCycleMethod = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].isAnnotationPresent(annotation)) continue;
            if (lifeCycleMethod != null || methods[i].getParameterTypes().length != 0 || Modifier.isStatic(methods[i].getModifiers()) || methods[i].getExceptionTypes().length > 0 || !methods[i].getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PostConstruct method.");
            }
            lifeCycleMethod = methods[i];
        }
        return lifeCycleMethod;
    }

    private boolean checkInjectionContainer() {
        return this.injectionContainer != null;
    }
}

