/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;
import org.jboss.web.tomcat.service.session.SnapshotManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingDistributableSessionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntervalSnapshotManager
extends SnapshotManager
implements Runnable {
    static Logger log = Logger.getLogger(IntervalSnapshotManager.class);
    private int interval = 1000;
    private Set<ClusteredSession<? extends OutgoingDistributableSessionData>> sessions = new LinkedHashSet<ClusteredSession<? extends OutgoingDistributableSessionData>>();
    private Thread thread = null;
    private boolean processingAllowed = false;
    private boolean threadDone = false;

    public IntervalSnapshotManager(AbstractJBossManager manager, String path) {
        super(manager, path);
    }

    public IntervalSnapshotManager(AbstractJBossManager manager, String path, int interval) {
        super(manager, path);
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshot(ClusteredSession<? extends OutgoingDistributableSessionData> session) {
        try {
            Set<ClusteredSession<? extends OutgoingDistributableSessionData>> set = this.sessions;
            synchronized (set) {
                this.sessions.add(session);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to queue session " + session + " for replication"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSessions() {
        HashSet<ClusteredSession<? extends OutgoingDistributableSessionData>> toProcess = null;
        Set<ClusteredSession<? extends OutgoingDistributableSessionData>> set = this.sessions;
        synchronized (set) {
            toProcess = new HashSet<ClusteredSession<? extends OutgoingDistributableSessionData>>(this.sessions);
            this.sessions.clear();
        }
        AbstractJBossManager mgr = this.getManager();
        for (ClusteredSession clusteredSession : toProcess) {
            if (!this.processingAllowed) break;
            try {
                mgr.storeSession(clusteredSession);
            }
            catch (Exception e) {
                this.getLog().error((Object)("Caught exception processing session " + clusteredSession.getRealId()), (Throwable)e);
            }
        }
    }

    @Override
    public void start() {
        this.processingAllowed = true;
        this.startThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.processingAllowed = false;
        this.stopThread();
        Set<ClusteredSession<? extends OutgoingDistributableSessionData>> set = this.sessions;
        synchronized (set) {
            this.sessions.clear();
        }
    }

    protected void startThread() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread((Runnable)this, "ClusteredSessionDistributor[" + this.getContextPath() + "]");
        this.thread.setDaemon(true);
        this.thread.setContextClassLoader(this.getManager().getContainer().getLoader().getClassLoader());
        this.threadDone = false;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopThread() {
        boolean intr = false;
        try {
            if (this.thread == null) {
                Object var4_2 = null;
                if (intr) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            this.threadDone = true;
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                intr = true;
            }
            this.thread = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (intr) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        Object var4_3 = null;
        if (intr) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean intr = false;
        try {
            while (!this.threadDone) {
                try {
                    Thread.sleep(this.interval);
                    this.processSessions();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    if (this.threadDone) continue;
                    this.getLog().error((Object)"Caught exception processing sessions", (Throwable)ie);
                }
                catch (Exception e) {
                    this.getLog().error((Object)"Caught exception processing sessions", (Throwable)e);
                }
            }
            Object var4_5 = null;
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (intr) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
    }
}

