/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.CodeSource;
import java.util.Map;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.tomcat.security.HttpServletRequestPolicyContextHandler;
import org.jboss.web.tomcat.security.SecurityAssociationActions;
import org.jboss.web.tomcat.security.SecurityAssociationValve;
import org.jboss.web.tomcat.service.request.ActiveRequestResponseCacheValve;

public class JaccContextValve
extends ValveBase {
    private static Logger log = Logger.getLogger(JaccContextValve.class);
    public static ThreadLocal<CodeSource> activeCS = new ThreadLocal();
    private String contextID;
    private CodeSource warCS;
    private JBossWebMetaData metaData;
    private boolean trace;

    public JaccContextValve(JBossWebMetaData wmd, CodeSource cs) {
        this.metaData = wmd;
        this.contextID = this.metaData.getJaccContextID();
        this.warCS = cs;
        this.trace = log.isTraceEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        SecurityAssociationValve.activeWebMetaData.set(this.metaData);
        activeCS.set(this.warCS);
        HttpServletRequest httpRequest = request.getRequest();
        Map principalToRoleSetMap = this.metaData.getPrincipalVersusRolesMap();
        SecurityRolesAssociation.setSecurityRoles((Map)principalToRoleSetMap);
        if (this.trace) {
            log.trace((Object)("MetaData:" + this.metaData + ":principalToRoleSetMap" + principalToRoleSetMap));
        }
        try {
            PolicyContext.setContextID((String)this.contextID);
            HttpServletRequestPolicyContextHandler.setRequest(httpRequest);
            if (ActiveRequestResponseCacheValve.activeRequest.get() == null) {
                ActiveRequestResponseCacheValve.activeRequest.set(request);
            }
            if (ActiveRequestResponseCacheValve.activeResponse.get() == null) {
                ActiveRequestResponseCacheValve.activeResponse.set(response);
            }
            this.getNext().invoke(request, response);
            Object var6_5 = null;
            SecurityAssociationValve.activeWebMetaData.set(null);
            ActiveRequestResponseCacheValve.activeRequest.set(null);
            ActiveRequestResponseCacheValve.activeResponse.set(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            SecurityAssociationValve.activeWebMetaData.set(null);
            ActiveRequestResponseCacheValve.activeRequest.set(null);
            ActiveRequestResponseCacheValve.activeResponse.set(null);
            SecurityAssociationActions.clear();
            activeCS.set(null);
            SecurityRolesAssociation.setSecurityRoles(null);
            HttpServletRequestPolicyContextHandler.setRequest(null);
            throw throwable;
        }
        SecurityAssociationActions.clear();
        activeCS.set(null);
        SecurityRolesAssociation.setSecurityRoles(null);
        HttpServletRequestPolicyContextHandler.setRequest(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        SecurityAssociationValve.activeWebMetaData.set(this.metaData);
        activeCS.set(this.warCS);
        HttpServletRequest httpRequest = request.getRequest();
        Map principalToRoleSetMap = this.metaData.getPrincipalVersusRolesMap();
        SecurityRolesAssociation.setSecurityRoles((Map)principalToRoleSetMap);
        if (this.trace) {
            log.trace((Object)("MetaData:" + this.metaData + ":principalToRoleSetMap" + principalToRoleSetMap));
        }
        try {
            PolicyContext.setContextID((String)this.contextID);
            HttpServletRequestPolicyContextHandler.setRequest(httpRequest);
            if (ActiveRequestResponseCacheValve.activeRequest.get() == null) {
                ActiveRequestResponseCacheValve.activeRequest.set(request);
            }
            if (ActiveRequestResponseCacheValve.activeResponse.get() == null) {
                ActiveRequestResponseCacheValve.activeResponse.set(response);
            }
            this.getNext().event(request, response, event);
            Object var7_6 = null;
            SecurityAssociationValve.activeWebMetaData.set(null);
            ActiveRequestResponseCacheValve.activeRequest.set(null);
            ActiveRequestResponseCacheValve.activeResponse.set(null);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            SecurityAssociationValve.activeWebMetaData.set(null);
            ActiveRequestResponseCacheValve.activeRequest.set(null);
            ActiveRequestResponseCacheValve.activeResponse.set(null);
            SecurityAssociationActions.clear();
            activeCS.set(null);
            SecurityRolesAssociation.setSecurityRoles(null);
            HttpServletRequestPolicyContextHandler.setRequest(null);
            throw throwable;
        }
        SecurityAssociationActions.clear();
        activeCS.set(null);
        SecurityRolesAssociation.setSecurityRoles(null);
        HttpServletRequestPolicyContextHandler.setRequest(null);
    }
}

