/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.security;

import java.io.IOException;
import java.security.PrivilegedActionException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityUtil;
import org.jboss.servlet.http.HttpEvent;
import org.jboss.web.tomcat.security.SecurityAssociationActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityContextEstablishmentValve
extends ValveBase {
    private String configuredSecurityDomainName;
    private ISecurityManagement securityManagement;
    private Class<?> securityContextClass;

    public SecurityContextEstablishmentValve(String configuredSecurityDomain, String defaultSecurityDomain, Class<?> contextClass, ISecurityManagement securityManagement) {
        String securityDomain = defaultSecurityDomain;
        if (configuredSecurityDomain != null) {
            securityDomain = configuredSecurityDomain;
        }
        this.configuredSecurityDomainName = SecurityUtil.unprefixSecurityDomain((String)securityDomain);
        this.securityContextClass = contextClass;
        this.securityManagement = securityManagement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        SecurityContext cachedContext = null;
        boolean createdSecurityContext = false;
        SecurityContext sc = SecurityAssociationActions.getSecurityContext();
        if (sc != null && !sc.getSecurityDomain().equals(this.configuredSecurityDomainName)) {
            cachedContext = sc;
            SecurityContext newSC = this.createSecurityContext();
            SecurityAssociationActions.setSecurityContext(newSC);
            createdSecurityContext = true;
        }
        if (sc == null) {
            sc = this.createSecurityContext();
            SecurityAssociationActions.setSecurityContext(sc);
            createdSecurityContext = true;
        }
        try {
            this.getNext().invoke(request, response);
        }
        finally {
            if (createdSecurityContext) {
                SecurityAssociationActions.clearSecurityContext();
            }
            if (cachedContext != null) {
                SecurityAssociationActions.setSecurityContext(cachedContext);
            }
        }
    }

    private SecurityContext createSecurityContext() {
        SecurityContext securityContext = null;
        try {
            securityContext = SecurityAssociationActions.createSecurityContext(this.configuredSecurityDomainName, this.securityContextClass);
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
        securityContext.setSecurityManagement(this.securityManagement);
        return securityContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(Request request, Response response, HttpEvent event) throws IOException, ServletException {
        SecurityContext cachedContext = null;
        boolean createdSecurityContext = false;
        SecurityContext sc = SecurityAssociationActions.getSecurityContext();
        if (sc != null && !sc.getSecurityDomain().equals(this.configuredSecurityDomainName)) {
            cachedContext = sc;
            SecurityContext newSC = this.createSecurityContext();
            SecurityAssociationActions.setSecurityContext(newSC);
            createdSecurityContext = true;
        }
        if (sc == null) {
            sc = this.createSecurityContext();
            SecurityAssociationActions.setSecurityContext(sc);
            createdSecurityContext = true;
        }
        try {
            this.getNext().event(request, response, event);
        }
        finally {
            if (createdSecurityContext) {
                SecurityAssociationActions.clearSecurityContext();
            }
            if (cachedContext != null) {
                SecurityAssociationActions.setSecurityContext(cachedContext);
            }
        }
    }
}

