/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.ondemand;

import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import org.jboss.logging.Logger;
import org.jboss.profileservice.profile.metadata.BasicProfileMetaData;
import org.jboss.profileservice.profile.metadata.helpers.ProfileMetaDataFactory;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;
import org.jboss.web.tomcat.service.ondemand.ContextDemandListener;
import org.jboss.web.tomcat.service.ondemand.OnDemandContextIntegrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnDemandContextProfileManager {
    public static final String DEFAULT_SERVICE_NAME = "jboss.web";
    public static final String DEFAULT_HOST_NAME = "localhost";
    public static final String DEFAULT_ROOT_WAR_PROFILE_NAME = "ROOT.war";
    private ProfileService profileService;
    private OnDemandContextIntegrator contextIntegrator;
    private URI deploymentRoot;
    private Collection<String> deploymentNames;
    protected final Logger log = Logger.getLogger(this.getClass());
    private boolean activated;
    private String profileDomain;
    private String profileServer;
    private String profileName;
    private ProfileKey profileKey;
    private String serviceName = "jboss.web";
    private String hostName = "localhost";
    private String contextName;
    private String contextPath;
    private boolean activateOnDemand = true;
    private final ContextDemandListener contextDemandListener = new Listener();

    public URI getDeploymentRoot() {
        return this.deploymentRoot;
    }

    public void setDeploymentRoot(URI deploymentRoot) {
        this.deploymentRoot = deploymentRoot;
    }

    public Collection<String> getDeploymentNames() {
        return this.deploymentNames;
    }

    public void setDeploymentNames(Collection<String> deploymentNames) {
        this.deploymentNames = deploymentNames;
    }

    public void setSingleDeployment(String name) {
        this.deploymentNames = Collections.singleton(name);
    }

    public String getProfileDomain() {
        return this.profileDomain;
    }

    public void setProfileDomain(String profileDomain) {
        this.profileDomain = profileDomain;
    }

    public String getProfileServer() {
        return this.profileServer;
    }

    public void setProfileServer(String profileServer) {
        this.profileServer = profileServer;
    }

    public String getProfileName() {
        if (this.profileName == null && this.contextName != null) {
            this.profileName = "".equals(this.contextName) ? DEFAULT_ROOT_WAR_PROFILE_NAME : this.contextName + ".war";
        }
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null");
        }
        this.serviceName = serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        if (hostName == null) {
            throw new IllegalArgumentException("hostName is null");
        }
        this.hostName = hostName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("contextName is null");
        }
        if ("ROOT".equals(contextName) || "/ROOT".equals(contextName)) {
            contextName = "";
        }
        this.contextName = contextName;
    }

    public void setProfileService(ProfileService profileService) {
        if (profileService == null) {
            throw new IllegalArgumentException("profileService is null");
        }
        this.profileService = profileService;
    }

    public void setOnDemandContextIntegrator(OnDemandContextIntegrator contextManager) {
        if (contextManager == null) {
            throw new IllegalArgumentException("contextManager is null");
        }
        this.contextIntegrator = contextManager;
    }

    public boolean isActivateOnDemand() {
        return this.activateOnDemand;
    }

    public void setActivateOnDemand(boolean activateOnDemand) {
        this.activateOnDemand = activateOnDemand;
    }

    public void start() throws Exception {
        if (this.profileService == null) {
            throw new IllegalStateException("Must configure ProfileService");
        }
        if (this.contextIntegrator == null) {
            throw new IllegalStateException("Must configure OnDemandContextManager");
        }
        if (this.serviceName == null) {
            throw new IllegalStateException("Must configure serviceName");
        }
        if (this.hostName == null) {
            throw new IllegalStateException("Must configure hostName");
        }
        if (this.contextName == null) {
            throw new IllegalStateException("Must configure contextName");
        }
        if (this.deploymentRoot == null) {
            throw new IllegalStateException("Must configure deployment root");
        }
        if (this.deploymentNames == null) {
            throw new IllegalStateException("Must configure deployment name");
        }
        String[] rootSubProfiles = new String[]{};
        BasicProfileMetaData metadata = ProfileMetaDataFactory.createFilteredProfileMetaData((String)this.getProfileName(), (URI)this.deploymentRoot, (String[])this.deploymentNames.toArray(new String[this.deploymentNames.size()]));
        this.profileKey = this.profileService.registerProfile((ProfileMetaData)metadata);
        if (this.activateOnDemand) {
            this.contextIntegrator.registerContextDemandListener(this.contextDemandListener);
            this.contextPath = this.contextName.length() == 0 || '/' == this.contextName.charAt(0) ? this.contextName : "/" + this.contextName;
            this.contextIntegrator.registerOnDemandContext(this.serviceName, this.hostName, this.contextPath);
        } else {
            this.activateProfile(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        ProfileKey profKey = null;
        try {
            profKey = this.getProfileKey();
        }
        catch (IllegalStateException e) {
            return;
        }
        if (this.profileService != null && profKey != null) {
            try {
                if (this.profileService.getActiveProfileKeys().contains(profKey)) {
                    this.releaseProfile();
                }
                this.profileService.unregisterProfile(profKey);
            }
            catch (NoSuchProfileException e) {
                this.log.warn((Object)("Could not unregister unknown profile " + profKey));
            }
            finally {
                if (this.contextIntegrator != null) {
                    this.contextIntegrator.removeContextDemandListener(this.contextDemandListener);
                }
            }
        }
    }

    public void activateProfile() throws Exception {
        this.activateProfile(true);
    }

    public ProfileKey getProfileKey() {
        if (this.profileKey == null) {
            String name = this.getProfileName();
            if (name == null) {
                throw new IllegalStateException("Must configure profileName or contextName before calling getProfileKey()");
            }
            this.profileKey = new ProfileKey(this.getProfileDomain(), this.getProfileServer(), this.getProfileName());
        }
        return this.profileKey;
    }

    private synchronized void activateProfile(boolean validate) throws Exception {
        if (this.profileService == null) {
            throw new IllegalStateException("Must configure the ProfileService");
        }
        ProfileKey profKey = this.getProfileKey();
        if (!this.profileService.getActiveProfileKeys().contains(profKey)) {
            this.profileService.activateProfile(profKey);
            if (validate) {
                this.profileService.validateProfile(profKey);
            }
            this.activated = true;
        } else {
            this.log.warn((Object)("Profile " + profKey + " is already activated"));
            this.activated = true;
        }
    }

    private synchronized void releaseProfile() throws Exception {
        if (this.activated) {
            try {
                this.profileService.deactivateProfile(this.getProfileKey());
            }
            catch (NoSuchProfileException e) {
                this.log.warn((Object)("No Profile is registered under key " + this.getProfileKey()));
            }
            this.activated = false;
        }
    }

    private class Listener
    implements ContextDemandListener {
        private Listener() {
        }

        public void contextDemanded(String serviceName, String hostName, String contextName) {
            if (OnDemandContextProfileManager.this.contextPath.equals(contextName) && OnDemandContextProfileManager.this.hostName.equals(hostName) && OnDemandContextProfileManager.this.serviceName.equals(serviceName)) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            OnDemandContextProfileManager.this.activateProfile();
                        }
                        catch (Exception e) {
                            OnDemandContextProfileManager.this.log.error((Object)("Unable to activate profile " + OnDemandContextProfileManager.this.getProfileKey()), (Throwable)e);
                        }
                        return null;
                    }
                });
            }
        }
    }
}

