/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.session.AbstractJBossManager;
import org.jboss.web.tomcat.service.session.ClusteredSession;

public class JvmRouteValve
extends ValveBase
implements Lifecycle {
    private static final String info = "JvmRouteValve/1.0";
    protected static Logger log_ = Logger.getLogger(JvmRouteValve.class);
    protected LifecycleSupport support = new LifecycleSupport((Lifecycle)this);
    protected AbstractJBossManager manager_;

    public JvmRouteValve(AbstractJBossManager manager) {
        this.manager_ = manager;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.checkJvmRoute(request, response);
        this.getNext().invoke(request, response);
    }

    public void checkJvmRoute(Request req, Response res) throws IOException, ServletException {
        String requestedId = req.getRequestedSessionId();
        HttpSession session = req.getSession(false);
        if (session != null) {
            String sessionId = session.getId();
            String jvmRoute = this.manager_.getJvmRoute();
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("checkJvmRoute(): check if need to re-route based on JvmRoute. Session id: " + sessionId + " jvmRoute: " + jvmRoute));
            }
            if (jvmRoute != null) {
                boolean setCookie = !req.isRequestedSessionIdFromURL();
                this.handleJvmRoute(requestedId, sessionId, jvmRoute, (HttpServletResponse)res, setCookie);
            }
        }
    }

    protected void handleJvmRoute(String requestedId, String sessionId, String jvmRoute, HttpServletResponse response, boolean setCookie) throws IOException {
        String newId = null;
        String sessionJvmRoute = null;
        int index = sessionId.indexOf(46, 0);
        if (index > -1 && index < sessionId.length() - 1) {
            sessionJvmRoute = sessionId.substring(index + 1, sessionId.length());
        }
        if (!jvmRoute.equals(sessionJvmRoute)) {
            if (index < 0) {
                newId = sessionId + '.' + jvmRoute;
            } else {
                if (log_.isTraceEnabled()) {
                    log_.trace((Object)("handleJvmRoute(): We have detected a failover with different jvmRoute. old one: " + sessionJvmRoute + " new one: " + jvmRoute + ". Will reset the session id."));
                }
                String base = sessionId.substring(0, index);
                newId = base + "." + jvmRoute;
            }
            this.resetSessionId(sessionId, newId);
        }
        if (setCookie) {
            if (newId == null) {
                int reqIndex;
                String requestedJvmRoute = null;
                if (requestedId != null && (reqIndex = requestedId.indexOf(46, 0)) > -1 && reqIndex < requestedId.length() - 1) {
                    requestedJvmRoute = requestedId.substring(reqIndex + 1, requestedId.length());
                }
                if (!jvmRoute.equals(requestedJvmRoute)) {
                    if (log_.isTraceEnabled()) {
                        log_.trace((Object)("handleJvmRoute(): We have detected a failover with different jvmRoute. received one: " + requestedJvmRoute + " new one: " + jvmRoute + ". Will resent the session id."));
                    }
                    String base = index > -1 ? sessionId.substring(0, index) : sessionId;
                    newId = base + '.' + jvmRoute;
                }
            }
            if (newId != null) {
                this.manager_.setNewSessionCookie(newId, response);
            }
        }
    }

    private void resetSessionId(String oldId, String newId) throws IOException {
        ClusteredSession session = (ClusteredSession)this.manager_.findSession(oldId);
        if (session != null) {
            session.resetIdWithRouteInfo(newId);
            if (log_.isTraceEnabled()) {
                log_.trace((Object)("resetSessionId(): changed catalina session to= [" + newId + "] old one= [" + oldId + "]"));
            }
        } else if (log_.isTraceEnabled()) {
            log_.trace((Object)("resetSessionId(): no session with id " + newId + " found"));
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.support.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.support.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.support.findLifecycleListeners();
    }

    public void start() throws LifecycleException {
        this.support.fireLifecycleEvent("start", (Object)this);
    }

    public void stop() throws LifecycleException {
        this.support.fireLifecycleEvent("stop", (Object)this);
    }
}

