/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.services.binding.ServiceBindingValueSource;

public class ServiceBinding {
    private final String serviceName;
    private final String bindingName;
    private final String hostName;
    private final int port;
    private final InetAddress bindAddress;
    private String serviceBindingValueSourceClassName;
    private ServiceBindingValueSource serviceBindingValueSource;
    private Object serviceBindingValueSourceConfig;

    public static String canonicalizeServiceName(String serviceName) {
        try {
            ObjectName oname = new ObjectName(serviceName);
            return oname.getCanonicalName();
        }
        catch (MalformedObjectNameException e) {
            return serviceName;
        }
    }

    public ServiceBinding(String serviceName, int port) throws UnknownHostException {
        this(serviceName, null, port);
    }

    public ServiceBinding(String serviceName, String hostName, int port) throws UnknownHostException {
        this(serviceName, null, hostName, port);
    }

    public ServiceBinding(String serviceName, String bindingName, String hostName, int port) throws UnknownHostException {
        if (serviceName == null) {
            throw new IllegalArgumentException("serviceName is null");
        }
        this.serviceName = ServiceBinding.canonicalizeServiceName(serviceName);
        this.bindingName = bindingName;
        this.port = port;
        this.hostName = hostName;
        this.bindAddress = InetAddress.getByName(hostName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public synchronized ServiceBindingValueSource getServiceBindingValueSource() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (this.serviceBindingValueSource == null && this.serviceBindingValueSourceClassName != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> delegateClass = loader.loadClass(this.serviceBindingValueSourceClassName);
            this.serviceBindingValueSource = (ServiceBindingValueSource)delegateClass.newInstance();
        }
        return this.serviceBindingValueSource;
    }

    public void setServiceBindingValueSource(ServiceBindingValueSource serviceBindingValueSource) {
        this.serviceBindingValueSource = serviceBindingValueSource;
        if (serviceBindingValueSource != null) {
            this.setServiceBindingValueSourceClassName(serviceBindingValueSource.getClass().getName());
        }
    }

    public String getServiceBindingValueSourceClassName() {
        return this.serviceBindingValueSourceClassName;
    }

    public void setServiceBindingValueSourceClassName(String serviceBindingValueSourceClassName) {
        this.serviceBindingValueSourceClassName = serviceBindingValueSourceClassName;
    }

    public Object getServiceBindingValueSourceConfig() {
        return this.serviceBindingValueSourceConfig;
    }

    public void setServiceBindingValueSourceConfig(Object serviceBindingValueSourceConfig) {
        this.serviceBindingValueSourceConfig = serviceBindingValueSourceConfig;
    }

    public ServiceBinding getOffsetBinding(int offset) throws UnknownHostException {
        ServiceBinding result = new ServiceBinding(this.serviceName, this.bindingName, this.hostName, this.port + offset);
        result.setServiceBindingValueSourceClassName(this.serviceBindingValueSourceClassName);
        result.setServiceBindingValueSource(this.serviceBindingValueSource);
        result.setServiceBindingValueSourceConfig(this.serviceBindingValueSourceConfig);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceBinding) {
            ServiceBinding other = (ServiceBinding)obj;
            return this.serviceName.equals(other.serviceName) && this.safeEquals(this.bindingName, other.bindingName);
        }
        return false;
    }

    public int hashCode() {
        int result = 19;
        result += 29 * this.serviceName.hashCode();
        return result += 29 * (this.bindingName == null ? 0 : this.bindingName.hashCode());
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer("ServiceBinding [serviceName=");
        sBuf.append(this.serviceName);
        sBuf.append(";bindingName=");
        sBuf.append(this.getBindingName());
        sBuf.append(";hostName=");
        String host = this.getHostName();
        if (this.hostName == null) {
            host = "<ANY>";
        }
        sBuf.append(host);
        sBuf.append(";bindAddress=");
        sBuf.append(this.getBindAddress().toString());
        sBuf.append(";port=");
        sBuf.append(this.getPort());
        sBuf.append("]");
        return sBuf.toString();
    }

    private boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

