/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.services.binding.DuplicateServiceException;
import org.jboss.services.binding.NoSuchBindingException;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceBindingStore;
import org.jboss.services.binding.impl.ServiceBindingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoServiceBindingStore
implements ServiceBindingStore {
    private static final Object VALUE = new Object();
    private final ConcurrentMap<ServiceBindingKey, ServiceBinding> bindings = new ConcurrentHashMap<ServiceBindingKey, ServiceBinding>(16, 0.75f, 4);
    private final ConcurrentMap<String, Object> bindingSetNames = new ConcurrentHashMap<String, Object>(16, 0.75f, 4);
    private final Map<String, String> defaultHostNames = new HashMap<String, String>();
    private final Map<String, InetAddress> defaultBindAddresses = new HashMap<String, InetAddress>();
    private final Map<String, Integer> defaultPortOffsets = new HashMap<String, Integer>();

    public PojoServiceBindingStore(Map<String, ServiceBindingSet> configSets) throws DuplicateServiceException {
        if (configSets == null) {
            throw new IllegalArgumentException("configSets is null");
        }
        for (Map.Entry<String, ServiceBindingSet> entry : configSets.entrySet()) {
            String serverName = entry.getKey();
            this.bindingSetNames.put(serverName, VALUE);
            ServiceBindingSet bindingSet = entry.getValue();
            this.defaultHostNames.put(serverName, bindingSet.getDefaultHostName());
            this.defaultBindAddresses.put(serverName, bindingSet.getDefaultBindAddress());
            this.defaultPortOffsets.put(serverName, bindingSet.getPortOffset());
            for (ServiceBinding binding : bindingSet) {
                this.addServiceBinding(serverName, binding);
            }
        }
    }

    @Override
    public void addServiceBinding(String serverName, ServiceBinding binding) throws DuplicateServiceException {
        this.validateServerName(serverName);
        ServiceBinding oldBinding = this.bindings.putIfAbsent(new ServiceBindingKey(serverName, binding), binding);
        if (oldBinding != null) {
            throw new DuplicateServiceException(serverName, binding);
        }
    }

    @Override
    public ServiceBinding getServiceBinding(String serverName, String serviceName, String bindingName) throws NoSuchBindingException {
        ServiceBinding binding = (ServiceBinding)this.bindings.get(new ServiceBindingKey(serverName, serviceName, bindingName));
        if (binding == null) {
            throw new NoSuchBindingException(serverName, serviceName, bindingName);
        }
        return binding;
    }

    @Override
    public void removeServiceBinding(String serverName, ServiceBinding binding) {
        this.validateServerName(serverName);
        this.bindings.remove(new ServiceBindingKey(serverName, binding));
    }

    @Override
    public void removeServiceBinding(String serverName, String serviceName, String bindingName) {
        this.validateServerName(serverName);
        this.bindings.remove(new ServiceBindingKey(serverName, serviceName, bindingName));
    }

    @Override
    public void addServiceBinding(ServiceBinding binding) throws DuplicateServiceException {
        for (String serverName : this.bindingSetNames.keySet()) {
            int port = binding.getPort() + this.getDefaultPortOffset(serverName);
            String hostName = binding.getHostName();
            if (hostName == null) {
                hostName = this.getDefaultHostName(serverName);
            }
            try {
                this.addServiceBinding(serverName, new ServiceBinding(binding.getServiceName(), binding.getBindingName(), hostName, port));
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Cannot convert " + hostName + " into an InetAddress");
            }
        }
    }

    @Override
    public void removeServiceBinding(ServiceBinding binding) {
        for (String serverName : this.bindingSetNames.keySet()) {
            this.removeServiceBinding(serverName, binding);
        }
    }

    @Override
    public void removeServiceBinding(String serviceName, String bindingName) {
        for (String serverName : this.bindingSetNames.keySet()) {
            this.removeServiceBinding(serverName, serviceName, bindingName);
        }
    }

    @Override
    public InetAddress getDefaultBindAddress(String serverName) {
        this.validateServerName(serverName);
        return this.defaultBindAddresses.get(serverName);
    }

    @Override
    public String getDefaultHostName(String serverName) {
        this.validateServerName(serverName);
        return this.defaultHostNames.get(serverName);
    }

    @Override
    public int getDefaultPortOffset(String serverName) {
        this.validateServerName(serverName);
        return this.defaultPortOffsets.get(serverName);
    }

    private void validateServerName(String serverName) {
        if (!this.bindingSetNames.containsKey(serverName)) {
            throw new IllegalArgumentException("unknown serverName " + serverName);
        }
    }

    private static class ServiceBindingKey {
        private final String serverName;
        private final String serviceName;
        private final String bindingName;

        private ServiceBindingKey(String serverName, ServiceBinding binding) {
            this(serverName, binding.getServiceName(), binding.getBindingName());
        }

        private ServiceBindingKey(String serverName, String serviceName, String bindingName) {
            assert (serverName != null) : "serverName is null";
            assert (serviceName != null) : "serviceName is null";
            this.serverName = serverName;
            this.serviceName = ServiceBinding.canonicalizeServiceName(serviceName);
            this.bindingName = bindingName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ServiceBindingKey) {
                ServiceBindingKey other = (ServiceBindingKey)obj;
                return this.serverName.equals(other.serverName) && this.serviceName.equals(other.serviceName) && this.safeEquals(this.bindingName, other.bindingName);
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result += 23 * this.serverName.hashCode();
            result += 23 * this.serviceName.hashCode();
            return result += 23 * (this.bindingName == null ? 0 : this.bindingName.hashCode());
        }

        private boolean safeEquals(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }
}

