/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.srp.jaas;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.Naming;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.crypto.CryptoUtil;
import org.jboss.logging.Logger;
import org.jboss.security.auth.callback.ByteArrayCallback;
import org.jboss.security.srp.SRPClientSession;
import org.jboss.security.srp.SRPParameters;
import org.jboss.security.srp.SRPServerInterface;
import org.jboss.security.srp.jaas.SRPPrincipal;

public class SRPLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler handler;
    private Map sharedState;
    private Hashtable jndiEnv;
    private String principalClassName;
    private String srpServerRmiUrl;
    private String srpServerJndiName;
    private String username;
    private char[] password;
    private SRPServerInterface srpServer;
    private SRPParameters params;
    private Principal userPrincipal;
    private Integer sessionID;
    private byte[] sessionKey;
    private byte[] abytes;
    private Object auxChallenge;
    private boolean externalRandomA;
    private boolean hasAuxChallenge;
    private boolean multipleSessions;
    private boolean loginFailed;
    private Logger log;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        this.log = Logger.getLogger(this.getClass());
        this.jndiEnv = new Hashtable(options);
        this.subject = subject;
        this.handler = handler;
        this.sharedState = sharedState;
        this.principalClassName = (String)options.get("principalClassName");
        if (this.principalClassName != null) {
            this.log.warn((Object)"The principalClassName is no longer used, its always SRPPrincipal");
        }
        this.srpServerJndiName = (String)options.get("srpServerJndiName");
        this.srpServerRmiUrl = (String)options.get("srpServerRmiUrl");
        String tmp = (String)options.get("externalRandomA");
        if (tmp != null) {
            this.externalRandomA = Boolean.valueOf(tmp);
        }
        this.multipleSessions = false;
        tmp = (String)options.get("multipleSessions");
        if (tmp != null) {
            this.multipleSessions = Boolean.valueOf(tmp);
        }
        if ((tmp = (String)options.get("hasAuxChallenge")) != null) {
            this.hasAuxChallenge = Boolean.valueOf(tmp);
        }
        this.jndiEnv.remove("principalClassName");
        this.jndiEnv.remove("srpServerJndiName");
        this.jndiEnv.remove("srpServerRmiUrl");
        this.jndiEnv.remove("externalRandomA");
        this.jndiEnv.remove("multipleSessions");
        this.jndiEnv.remove("hasAuxChallenge");
    }

    public boolean login() throws LoginException {
        byte[] M2;
        byte[] M1;
        boolean trace = this.log.isTraceEnabled();
        this.loginFailed = true;
        this.getUserInfo();
        if (this.srpServerJndiName != null) {
            this.srpServer = this.loadServerFromJndi(this.srpServerJndiName);
        } else if (this.srpServerRmiUrl != null) {
            this.srpServer = this.loadServer(this.srpServerRmiUrl);
        } else {
            throw new LoginException("No option specified to access a SRPServerInterface instance");
        }
        if (this.srpServer == null) {
            throw new LoginException("Failed to access a SRPServerInterface instance");
        }
        SRPClientSession client = null;
        try {
            if (trace) {
                this.log.trace((Object)("Getting SRP parameters for username: " + this.username));
            }
            CryptoUtil.init();
            Object[] sessionInfo = this.srpServer.getSRPParameters(this.username, this.multipleSessions);
            this.params = (SRPParameters)sessionInfo[0];
            this.sessionID = (Integer)sessionInfo[1];
            if (this.sessionID == null) {
                this.sessionID = new Integer(0);
            }
            if (trace) {
                this.log.trace((Object)("SessionID: " + this.sessionID));
                this.log.trace((Object)("N: " + CryptoUtil.tob64((byte[])this.params.N)));
                this.log.trace((Object)("g: " + CryptoUtil.tob64((byte[])this.params.g)));
                this.log.trace((Object)("s: " + CryptoUtil.tob64((byte[])this.params.s)));
                this.log.trace((Object)("cipherAlgorithm: " + this.params.cipherAlgorithm));
                this.log.trace((Object)("hashAlgorithm: " + this.params.hashAlgorithm));
            }
            byte[] hn = CryptoUtil.newDigest().digest(this.params.N);
            if (trace) {
                this.log.trace((Object)("H(N): " + CryptoUtil.tob64((byte[])hn)));
            }
            byte[] hg = CryptoUtil.newDigest().digest(this.params.g);
            if (trace) {
                this.log.trace((Object)("H(g): " + CryptoUtil.tob64((byte[])hg)));
                this.log.trace((Object)"Creating SRPClientSession");
            }
            client = this.abytes != null ? new SRPClientSession(this.username, this.password, this.params, this.abytes) : new SRPClientSession(this.username, this.password, this.params);
            if (trace) {
                this.log.trace((Object)"Generating client public key");
            }
            byte[] A = client.exponential();
            if (trace) {
                this.log.trace((Object)"Exchanging public keys");
            }
            byte[] B = this.srpServer.init(this.username, A, this.sessionID);
            if (trace) {
                this.log.trace((Object)"Generating server challenge");
            }
            M1 = client.response(B);
            if (trace) {
                this.log.trace((Object)"Exchanging challenges");
            }
            this.sessionKey = client.getSessionKey();
            if (this.auxChallenge != null) {
                this.auxChallenge = this.encryptAuxChallenge(this.auxChallenge, this.params.cipherAlgorithm, this.params.cipherIV, this.sessionKey);
                M2 = this.srpServer.verify(this.username, M1, this.auxChallenge, this.sessionID);
            } else {
                M2 = this.srpServer.verify(this.username, M1, this.sessionID);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to complete SRP login", (Throwable)e);
            throw new LoginException("Failed to complete SRP login, msg=" + e.getMessage());
        }
        if (trace) {
            this.log.trace((Object)"Verifying server response");
        }
        if (!client.verify(M2)) {
            throw new LoginException("Failed to validate server reply");
        }
        if (trace) {
            this.log.trace((Object)"Login succeeded");
        }
        this.userPrincipal = new SRPPrincipal(this.username, this.sessionID);
        this.sharedState.put("javax.security.auth.login.name", this.userPrincipal);
        this.sharedState.put("javax.security.auth.login.password", M1);
        this.loginFailed = false;
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.loginFailed) {
            return false;
        }
        this.subject.getPrincipals().add(this.userPrincipal);
        Set<Object> privateCredentials = this.subject.getPrivateCredentials();
        privateCredentials.add(this.sessionKey);
        if (this.sessionID != null) {
            privateCredentials.add(this.sessionID);
        }
        if (this.params.cipherAlgorithm != null) {
            Object secretKey = this.createSecretKey(this.params.cipherAlgorithm, this.sessionKey);
            privateCredentials.add(secretKey);
        }
        privateCredentials.add(this.params);
        return true;
    }

    public boolean abort() throws LoginException {
        this.username = null;
        this.password = null;
        return true;
    }

    public boolean logout() throws LoginException {
        try {
            if (!this.subject.isReadOnly()) {
                Set<?> s = this.subject.getPrincipals(this.userPrincipal.getClass());
                s.remove(this.userPrincipal);
                this.subject.getPrivateCredentials().remove(this.sessionKey);
            }
            if (this.srpServer != null) {
                this.srpServer.close(this.username, this.sessionID);
            }
        }
        catch (Exception e) {
            throw new LoginException("Failed to remove user principal, " + e.getMessage());
        }
        return true;
    }

    private void getUserInfo() throws LoginException {
        String _username = (String)this.sharedState.get("javax.security.auth.login.name");
        char[] _password = null;
        if (_username != null) {
            Object pw = this.sharedState.get("javax.security.auth.login.password");
            if (pw instanceof char[]) {
                _password = (char[])pw;
            } else if (pw != null) {
                _password = pw.toString().toCharArray();
            }
        }
        if (_username != null && _password != null) {
            this.username = _username;
            this.password = _password;
            return;
        }
        if (this.handler == null) {
            throw new LoginException("No CallbackHandler provied to SRPLoginModule");
        }
        NameCallback nc = new NameCallback("Username: ", "guest");
        PasswordCallback pc = new PasswordCallback("Password: ", false);
        ByteArrayCallback bac = new ByteArrayCallback("Public key random number: ");
        TextInputCallback tic = new TextInputCallback("Auxillary challenge token: ");
        ArrayList<Callback> tmpList = new ArrayList<Callback>();
        tmpList.add(nc);
        tmpList.add(pc);
        if (this.externalRandomA) {
            tmpList.add((Callback)bac);
        }
        if (this.hasAuxChallenge) {
            tmpList.add(tic);
        }
        Callback[] callbacks = new Callback[tmpList.size()];
        tmpList.toArray(callbacks);
        try {
            this.handler.handle(callbacks);
            this.username = nc.getName();
            _password = pc.getPassword();
            if (_password != null) {
                this.password = _password;
            }
            pc.clearPassword();
            if (this.externalRandomA) {
                this.abytes = bac.getByteArray();
            }
            if (this.hasAuxChallenge) {
                this.auxChallenge = tic.getText();
            }
        }
        catch (IOException e) {
            throw new LoginException(e.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("UnsupportedCallback: " + uce.getCallback().toString());
        }
    }

    private SRPServerInterface loadServerFromJndi(String jndiName) {
        SRPServerInterface server = null;
        try {
            InitialContext ctx = new InitialContext(this.jndiEnv);
            server = (SRPServerInterface)ctx.lookup(jndiName);
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to lookup(" + jndiName + ")"), (Throwable)e);
        }
        return server;
    }

    private SRPServerInterface loadServer(String rmiUrl) {
        SRPServerInterface server = null;
        try {
            server = (SRPServerInterface)((Object)Naming.lookup(rmiUrl));
        }
        catch (Exception e) {
            this.log.error((Object)("Failed to lookup(" + rmiUrl + ")"), (Throwable)e);
        }
        return server;
    }

    private Object encryptAuxChallenge(Object challenge, String cipherAlgorithm, byte[] cipherIV, Object key) throws LoginException {
        if (cipherAlgorithm == null) {
            return challenge;
        }
        Object sealedObject = null;
        try {
            Serializable data = (Serializable)challenge;
            Object tmpKey = CryptoUtil.createSecretKey((String)cipherAlgorithm, (Object)key);
            sealedObject = CryptoUtil.createSealedObject((String)cipherAlgorithm, (Object)tmpKey, (byte[])cipherIV, (Serializable)data);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to encrypt aux challenge", (Throwable)e);
            throw new LoginException("Failed to encrypt aux challenge");
        }
        return sealedObject;
    }

    private Object createSecretKey(String cipherAlgorithm, Object key) throws LoginException {
        Object secretKey = null;
        try {
            secretKey = CryptoUtil.createSecretKey((String)cipherAlgorithm, (Object)key);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to create SecretKey", (Throwable)e);
            throw new LoginException("Failed to create SecretKey");
        }
        return secretKey;
    }
}

