/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.jboss.services.binding.DuplicateServiceException;
import org.jboss.services.binding.ElementServiceBindingValueSource;
import org.jboss.services.binding.InetAddressServiceBindingValueSource;
import org.jboss.services.binding.IntServiceBindingValueSource;
import org.jboss.services.binding.NoSuchBindingException;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceBindingManagerMBean;
import org.jboss.services.binding.ServiceBindingStore;
import org.jboss.services.binding.ServiceBindingValueSource;
import org.jboss.services.binding.StringServiceBindingValueSource;
import org.jboss.services.binding.URLServiceBindingValueSource;
import org.jboss.services.binding.impl.SimpleServiceBindingValueSourceImpl;
import org.jboss.services.binding.impl.StringReplacementServiceBindingValueSourceImpl;
import org.jboss.services.binding.impl.Util;
import org.jboss.services.binding.impl.XSLTServiceBindingValueSourceConfig;
import org.jboss.services.binding.impl.XSLTServiceBindingValueSourceImpl;
import org.w3c.dom.Element;

public class ServiceBindingManager
implements ServiceBindingManagerMBean {
    private final String serverName;
    private final ServiceBindingStore store;

    public static ServiceBindingValueSource getServiceBindingValueSource(ServiceBinding binding, BindingType bindingType) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ServiceBindingValueSource source = binding.getServiceBindingValueSource();
        if (source == null) {
            switch (bindingType) {
                case INT: 
                case INETADDRESS: {
                    source = new SimpleServiceBindingValueSourceImpl();
                    break;
                }
                case STRING: {
                    source = new StringReplacementServiceBindingValueSourceImpl();
                    break;
                }
                case ELEMENT: 
                case URL: 
                case RESOURCE: {
                    Object config = binding.getServiceBindingValueSourceConfig();
                    if (config instanceof XSLTServiceBindingValueSourceConfig) {
                        source = new XSLTServiceBindingValueSourceImpl();
                        break;
                    }
                    source = new StringReplacementServiceBindingValueSourceImpl();
                    break;
                }
                default: {
                    throw new IllegalStateException("No ServiceBindingValueSource configured for " + binding + " and no default source available for binding of type " + (Object)((Object)bindingType));
                }
            }
        }
        return source;
    }

    public ServiceBindingManager(String serverName, ServiceBindingStore store) {
        if (serverName == null) {
            throw new IllegalArgumentException("serverName is null");
        }
        if (store == null) {
            throw new IllegalArgumentException("store is null");
        }
        this.serverName = serverName;
        this.store = store;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getIntBinding(String serviceName) throws Exception {
        return this.getIntBinding(serviceName, null);
    }

    public int getIntBinding(String serviceName, String bindingName) throws Exception {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.INT);
        if (source instanceof IntServiceBindingValueSource) {
            return ((IntServiceBindingValueSource)source).getIntServiceBindingValue(binding);
        }
        return Util.getBindingValue(source, binding, Number.class).intValue();
    }

    public int getIntBinding(String serviceName, String bindingName, String hostName, int basePort) throws Exception {
        try {
            return this.getIntBinding(serviceName, bindingName);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort);
            return this.getIntBinding(serviceName, bindingName);
        }
    }

    private void createBindingFromDefaults(String serviceName, String bindingName, String hostName, int basePort) throws UnknownHostException, DuplicateServiceException {
        ServiceBinding sb = new ServiceBinding(serviceName, bindingName, hostName, basePort);
        this.store.addServiceBinding(sb);
    }

    public InetAddress getInetAddressBinding(String serviceName) throws Exception {
        return this.getInetAddressBinding(serviceName, null);
    }

    public InetAddress getInetAddressBinding(String serviceName, String bindingName) throws Exception {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.INETADDRESS);
        if (source instanceof InetAddressServiceBindingValueSource) {
            return ((InetAddressServiceBindingValueSource)source).getInetAddressServiceBindingValue(binding);
        }
        return Util.getBindingValue(source, binding, InetAddress.class);
    }

    public InetAddress getInetAddressBinding(String serviceName, String bindingName, String hostName, int basePort) throws Exception {
        try {
            return this.getInetAddressBinding(serviceName, bindingName);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort);
            return this.getInetAddressBinding(serviceName, bindingName);
        }
    }

    public String getStringBinding(String serviceName, String input) throws Exception {
        return this.getStringBinding(serviceName, null, input);
    }

    public String getStringBinding(String serviceName, String bindingName, String input) throws Exception {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.STRING);
        if (source instanceof StringServiceBindingValueSource) {
            return ((StringServiceBindingValueSource)source).getStringServiceBindingValue(binding, input);
        }
        return Util.getBindingValueWithInput(source, binding, input, String.class);
    }

    public String getStringBinding(String serviceName, String bindingName, String input, String hostName, int basePort) throws Exception {
        try {
            return this.getStringBinding(serviceName, bindingName, input);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort);
            return this.getStringBinding(serviceName, bindingName, input);
        }
    }

    public Element getElementBinding(String serviceName, Element input) throws Exception {
        return this.getElementBinding(serviceName, null, input);
    }

    public Element getElementBinding(String serviceName, String bindingName, Element input) throws Exception {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.ELEMENT);
        if (source instanceof ElementServiceBindingValueSource) {
            return ((ElementServiceBindingValueSource)source).getElementServiceBindingValue(binding, input);
        }
        return Util.getBindingValueWithInput(source, binding, input, Element.class);
    }

    public Element getElementBinding(String serviceName, String bindingName, Element input, String hostName, int basePort) throws Exception {
        try {
            return this.getElementBinding(serviceName, bindingName, input);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort);
            return this.getElementBinding(serviceName, bindingName, input);
        }
    }

    public URL getURLBinding(String serviceName, URL input) throws Exception {
        return this.getURLBinding(serviceName, null, input);
    }

    public URL getURLBinding(String serviceName, String bindingName, URL input) throws Exception {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.URL);
        if (source instanceof URLServiceBindingValueSource) {
            return ((URLServiceBindingValueSource)source).getURLServiceBindingValue(binding, input);
        }
        return Util.getBindingValueWithInput(source, binding, input, URL.class);
    }

    public URL getURLBinding(String serviceName, String bindingName, URL input, String hostName, int basePort) throws Exception {
        try {
            return this.getURLBinding(serviceName, bindingName, input);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort);
            return this.getURLBinding(serviceName, bindingName, input);
        }
    }

    public String getResourceBinding(String serviceName, String input) throws Exception {
        return this.getResourceBinding(serviceName, null, input);
    }

    public String getResourceBinding(String serviceName, String bindingName, String input) throws Exception {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.RESOURCE);
        if (source instanceof URLServiceBindingValueSource) {
            return ((URLServiceBindingValueSource)source).getResourceServiceBindingValue(binding, input);
        }
        return Util.getBindingValueWithInput(source, binding, input, String.class);
    }

    public String getResourceBinding(String serviceName, String bindingName, String input, String hostName, int basePort) throws Exception {
        try {
            return this.getResourceBinding(serviceName, bindingName, input);
        }
        catch (NoSuchBindingException e) {
            this.createBindingFromDefaults(serviceName, bindingName, hostName, basePort);
            return this.getResourceBinding(serviceName, bindingName, input);
        }
    }

    public Object getGenericBinding(String serviceName, Object ... params) throws Exception {
        return this.getGenericBinding(serviceName, null, params);
    }

    public Object getGenericBinding(String serviceName, String bindingName, Object ... params) throws Exception {
        ServiceBinding binding = this.store.getServiceBinding(this.serverName, serviceName, bindingName);
        ServiceBindingValueSource source = ServiceBindingManager.getServiceBindingValueSource(binding, BindingType.GENERIC);
        return source.getServiceBindingValue(binding, params);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BindingType {
        INT,
        INETADDRESS,
        STRING,
        ELEMENT,
        URL,
        RESOURCE,
        GENERIC;

    }
}

