/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.deployment.convertor;

import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.jar.JarFile;
import javax.management.JMException;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.varia.deployment.convertor.Convertor;
import org.jboss.varia.deployment.convertor.JarTransformer;
import org.jboss.varia.deployment.convertor.WebLogicConvertorMBean;

public class WebLogicConvertor
extends ServiceMBeanSupport
implements Convertor,
WebLogicConvertorMBean {
    private String deployerName;
    private String wlVersion;
    private String removeTable;
    private String datasource;
    private String datasourceMapping;
    private Properties xslParams;

    public String getDeployer() {
        return this.deployerName;
    }

    public void setDeployer(String name) {
        if (this.deployerName != null && name != null && this.deployerName != name) {
            try {
                this.server.invoke(new ObjectName(this.deployerName), "removeConvertor", new Object[]{this}, new String[]{this.getClass().getName()});
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
        if (name != null) {
            this.deployerName = name;
        }
    }

    public String getWlVersion() {
        return this.wlVersion;
    }

    public void setWlVersion(String wlVersion) {
        this.wlVersion = wlVersion;
    }

    public String getRemoveTable() {
        return this.removeTable;
    }

    public void setRemoveTable(String removeTable) {
        this.removeTable = removeTable;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    public String getDatasourceMapping() {
        return this.datasourceMapping;
    }

    public void setDatasourceMapping(String datasourceMapping) {
        this.datasourceMapping = datasourceMapping;
    }

    public void startService() {
        try {
            this.initXslParams();
            this.server.invoke(new ObjectName(this.deployerName), "addConvertor", new Object[]{this}, new String[]{Convertor.class.getName()});
        }
        catch (JMException jme) {
            this.log.error((Object)"Caught exception during startService()", (Throwable)jme);
        }
    }

    public void stopService() {
        if (this.deployerName != null) {
            try {
                this.server.invoke(new ObjectName(this.deployerName), "removeConvertor", new Object[]{this}, new String[]{this.getClass().getName()});
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
    }

    public boolean accepts(URL url) {
        String stringUrl = url.toString();
        JarFile jarFile = null;
        boolean accepted = false;
        try {
            jarFile = new JarFile(url.getPath());
            accepted = jarFile.getEntry("META-INF/weblogic-ejb-jar.xml") != null && (stringUrl.endsWith(".wlar") || stringUrl.endsWith(".wl")) || stringUrl.endsWith(".war.wl") || stringUrl.endsWith(".ear.wl");
            jarFile.close();
        }
        catch (Exception e) {
            this.log.debug((Object)("Couldn't create JarFile for " + url.getPath()), (Throwable)e);
            return false;
        }
        return accepted;
    }

    public void convert(DeploymentInfo di, File path) throws Exception {
        Properties xslParams = this.getXslParams();
        JarTransformer.transform(path, xslParams);
    }

    public Properties getXslParams() {
        if (this.xslParams == null) {
            this.log.warn((Object)"xmlParams should have been initialized!");
            this.xslParams = this.initXslParams();
        }
        this.xslParams.setProperty("resources_path", "resources/" + this.wlVersion + "/");
        this.xslParams.setProperty("remove-table", this.removeTable);
        this.xslParams.setProperty("datasource", this.datasource);
        this.xslParams.setProperty("datasource-mapping", this.datasourceMapping);
        return this.xslParams;
    }

    private Properties initXslParams() {
        this.xslParams = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource("standardjboss.xml");
        if (url != null) {
            this.xslParams.setProperty("standardjboss", new File(url.getFile()).getAbsolutePath());
        } else {
            this.log.debug((Object)"standardjboss.xml not found.");
        }
        url = cl.getResource("standardjbosscmp-jdbc.xml");
        if (url != null) {
            this.xslParams.setProperty("standardjbosscmp-jdbc", new File(url.getFile()).getAbsolutePath());
        } else {
            this.log.debug((Object)"standardjbosscmp-jdbc.xml not found.");
        }
        this.log.debug((Object)("initialized xsl parameters: " + this.xslParams));
        return this.xslParams;
    }
}

