/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.deployment.convertor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XslTransformer {
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public static synchronized void applyTransformation(InputStream srcIs, OutputStream destOs, InputStream templateIs, Properties outputProps) throws TransformerException, IOException {
        StreamSource source = new StreamSource(srcIs);
        StreamResult result = new StreamResult(destOs);
        StreamSource template = new StreamSource(templateIs);
        Templates templates = transformerFactory.newTemplates(template);
        Transformer transformer = templates.newTransformer();
        if (outputProps != null) {
            transformer.setOutputProperties(outputProps);
        }
        transformer.transform(source, result);
    }

    public static synchronized void applyTransformation(InputStream srcIs, OutputStream destOs, InputStream templateIs, Properties outputProps, Properties xslParams) throws TransformerException, IOException {
        StreamSource source = new StreamSource(srcIs);
        StreamResult result = new StreamResult(destOs);
        StreamSource template = new StreamSource(templateIs);
        Templates templates = transformerFactory.newTemplates(template);
        Transformer transformer = templates.newTransformer();
        if (outputProps != null) {
            transformer.setOutputProperties(outputProps);
        }
        if (xslParams != null) {
            Enumeration<?> keys = xslParams.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                transformer.setParameter(key, xslParams.getProperty(key));
            }
        }
        transformer.transform(source, result);
    }
}

