/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.control;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;

public class AddressPort {
    InetAddress addr;
    Integer port;

    public static AddressPort getMemberAddress(Object addr) throws IOException {
        AddressPort info = null;
        try {
            Class[] parameterTypes = new Class[]{};
            Object[] args = new Object[]{};
            Method getIpAddress = addr.getClass().getMethod("getIpAddress", parameterTypes);
            InetAddress inetAddr = (InetAddress)getIpAddress.invoke(addr, args);
            Method getPort = addr.getClass().getMethod("getPort", parameterTypes);
            Integer port = (Integer)getPort.invoke(addr, args);
            info = new AddressPort(inetAddr, port);
        }
        catch (Exception e) {
            if (addr instanceof String) {
                String hostAddr = (String)addr;
                int colon = hostAddr.indexOf(58);
                String host = hostAddr;
                Integer port = new Integer(0);
                if (colon > 0) {
                    host = hostAddr.substring(0, colon);
                    port = Integer.valueOf(hostAddr.substring(colon + 1));
                }
                info = new AddressPort(InetAddress.getByName(host), port);
            }
            throw new IOException("Failed to parse addrType=" + addr.getClass() + ", msg=" + e.getMessage());
        }
        return info;
    }

    AddressPort(InetAddress addr, Integer port) {
        this.addr = addr;
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public InetAddress getInetAddress() {
        return this.addr;
    }

    public String getHostAddress() {
        return this.addr.getHostAddress();
    }

    public String getHostName() {
        return this.addr.getHostName();
    }

    public String toString() {
        return "{host(" + this.addr + "), port(" + this.port + ")}";
    }
}

