/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.threaddump;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadDumpBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Thread, StackTraceElement[]> stackTraces = new TreeMap<Thread, StackTraceElement[]>(THREAD_COMPARATOR);
    private static final Comparator<Thread> THREAD_COMPARATOR = new Comparator<Thread>(){

        @Override
        public int compare(Thread t1, Thread t2) {
            int result = t1.getName().compareTo(t2.getName());
            if (result == 0) {
                Long tid1 = t1.getId();
                Long tid2 = t2.getId();
                result = tid1.compareTo(tid2);
            }
            return result;
        }
    };

    public static final void main(String[] args) {
        ThreadDumpBean dump = new ThreadDumpBean();
        System.out.println(dump.getStackTraces());
    }

    public ThreadDumpBean() {
        this.stackTraces.putAll(Thread.getAllStackTraces());
    }

    public Collection<Thread> getThreads() {
        return this.stackTraces.keySet();
    }

    public Map<Thread, StackTraceElement[]> getStackTraces() {
        return this.stackTraces;
    }
}

