/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.services.binding.ServiceBindingMetadata;
import org.jboss.services.binding.ServiceBindingValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(componentType=@ManagementComponent(type="MCBean", subtype="ServiceBinding"), properties=ManagementProperties.EXPLICIT)
public class ServiceBinding
implements Comparable<ServiceBinding> {
    private final String serviceName;
    private final String bindingName;
    private final String fullyQualifiedName;
    private final String hostName;
    private final int port;
    private final InetAddress bindAddress;
    private String description;
    private final String serviceBindingValueSourceClassName;
    private final ServiceBindingValueSource serviceBindingValueSource;
    private final Object serviceBindingValueSourceConfig;

    public ServiceBinding(ServiceBindingMetadata metadata, String defaulHostName, int portOffset) throws UnknownHostException {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata is null");
        }
        if (metadata.getServiceName() == null) {
            throw new IllegalStateException("metadata's serviceName is null");
        }
        this.serviceName = metadata.getServiceName();
        this.bindingName = metadata.getBindingName();
        this.fullyQualifiedName = this.bindingName == null ? this.serviceName : this.serviceName + ":" + this.bindingName;
        this.port = metadata.isFixedPort() ? metadata.getPort() : metadata.getPort() + portOffset;
        this.hostName = metadata.isFixedHostName() ? metadata.getHostName() : defaulHostName;
        this.bindAddress = InetAddress.getByName(this.hostName);
        this.description = metadata.getDescription();
        this.serviceBindingValueSourceConfig = metadata.getServiceBindingValueSourceConfig();
        ServiceBindingValueSource valueSource = metadata.getServiceBindingValueSource();
        if (valueSource == null) {
            this.serviceBindingValueSourceClassName = metadata.getServiceBindingValueSourceClassName();
            if (this.serviceBindingValueSourceClassName != null) {
                try {
                    this.serviceBindingValueSource = AccessController.doPrivileged(new PrivilegedExceptionAction<ServiceBindingValueSource>(){

                        @Override
                        public ServiceBindingValueSource run() throws Exception {
                            ClassLoader loader = Thread.currentThread().getContextClassLoader();
                            Class<?> delegateClass = loader.loadClass(ServiceBinding.this.serviceBindingValueSourceClassName);
                            return (ServiceBindingValueSource)delegateClass.newInstance();
                        }
                    });
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed creating ServiceBindingValueSource of type " + this.serviceBindingValueSourceClassName, e);
                }
            } else {
                this.serviceBindingValueSource = null;
            }
        } else {
            this.serviceBindingValueSource = valueSource;
            this.serviceBindingValueSourceClassName = valueSource.getClass().getName();
        }
    }

    @ManagementProperty(description="the name of the service to which this binding applies")
    public String getServiceName() {
        return this.serviceName;
    }

    @ManagementProperty(description="a qualifier identifying which particular binding within the service this is")
    public String getBindingName() {
        return this.bindingName;
    }

    @ManagementProperty(description="the fully qualified binding name")
    @ManagementObjectID(type="ServiceBinding")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, description="the host name or string notation IP address to use for the binding")
    public String getHostName() {
        return this.hostName;
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, description="the port to use for the binding")
    public int getPort() {
        return this.port;
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, description="the InetAddress of the interface to use for the binding")
    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, description="description of the binding")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public synchronized ServiceBindingValueSource getServiceBindingValueSource() {
        return this.serviceBindingValueSource;
    }

    public String getServiceBindingValueSourceClassName() {
        return this.serviceBindingValueSourceClassName;
    }

    public Object getServiceBindingValueSourceConfig() {
        return this.serviceBindingValueSourceConfig;
    }

    @Override
    public int compareTo(ServiceBinding o) {
        return this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServiceBinding) {
            ServiceBinding other = (ServiceBinding)obj;
            return this.serviceName.equals(other.serviceName) && this.safeEquals(this.bindingName, other.bindingName);
        }
        return false;
    }

    public int hashCode() {
        int result = 19;
        result += 29 * this.serviceName.hashCode();
        return result += 29 * (this.bindingName == null ? 0 : this.bindingName.hashCode());
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer("ServiceBinding [serviceName=");
        sBuf.append(this.serviceName);
        sBuf.append(";bindingName=");
        sBuf.append(this.getBindingName());
        sBuf.append(";hostName=");
        String host = this.getHostName();
        if (this.hostName == null) {
            host = "<ANY>";
        }
        sBuf.append(host);
        sBuf.append(";bindAddress=");
        sBuf.append(this.getBindAddress().toString());
        sBuf.append(";port=");
        sBuf.append(this.getPort());
        sBuf.append("]");
        return sBuf.toString();
    }

    private boolean safeEquals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

