/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.services.binding.ServiceBindingMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(componentType=@ManagementComponent(type="MCBean", subtype="ServiceBindingSet"), properties=ManagementProperties.EXPLICIT)
public class ServiceBindingSet {
    private static final long serialVersionUID = 765380451233486038L;
    private final String bindingSetName;
    private String defaultHostName;
    private int portOffset;
    private final Set<ServiceBindingMetadata> overrides;

    public ServiceBindingSet(String name) {
        this(name, null, 0, null);
    }

    public ServiceBindingSet(String name, Set<ServiceBindingMetadata> overrides) {
        this(name, null, 0, overrides);
    }

    public ServiceBindingSet(String name, int offset) {
        this(name, null, offset, null);
    }

    public ServiceBindingSet(String name, String defaultHostName, int offset) {
        this(name, defaultHostName, offset, null);
    }

    public ServiceBindingSet(String name, String defaultHostName, int offset, Set<ServiceBindingMetadata> overrides) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.overrides = overrides == null ? new HashSet(0) : overrides;
        this.bindingSetName = name;
        this.defaultHostName = defaultHostName;
        this.portOffset = offset;
    }

    @ManagementProperty(description="the name of the set")
    @ManagementObjectID(type="ServiceBindingSet")
    public String getName() {
        return this.bindingSetName;
    }

    @ManagementProperty(description="the host name bindings associated with this set should use not configured in the binding itself")
    public String getDefaultHostName() {
        return this.defaultHostName;
    }

    public void setDefaultHostName(String defaultHostName) {
        this.defaultHostName = defaultHostName;
    }

    @ManagementProperty(description="offset that should be applied to non-fixed-portbindings associated with this set")
    public int getPortOffset() {
        return this.portOffset;
    }

    public void setPortOffset(int portOffset) {
        this.portOffset = portOffset;
    }

    @ManagementProperty(description="bindings that either override or are additions to the base bindings configured in the ServiceBindingStore")
    public Set<ServiceBindingMetadata> getOverrideBindings() {
        Set<ServiceBindingMetadata> result = this.overrides == null ? Collections.EMPTY_SET : this.overrides;
        return result;
    }
}

