/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jmx.adaptor.snmp.agent.MappingFailedException;
import org.jboss.logging.Logger;
import org.opennms.protocols.snmp.SnmpCounter64;
import org.opennms.protocols.snmp.SnmpInt32;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpVarBind;

public class SnmpVarBindFactory {
    private static final Logger log = Logger.getLogger(SnmpVarBindFactory.class);
    private Map makers = new HashMap();
    private final Maker defaultMaker = new SnmpObjectMaker();

    public SnmpVarBindFactory() {
        this.makers.put("java.lang.String", new SnmpOctetStringMaker());
        this.makers.put("java.lang.Integer", new SnmpInt32Maker());
        this.makers.put("java.lang.Long", new SnmpCounter64Maker());
        this.makers.put("java.math.BigInteger", new SnmpCounter64Maker());
        this.makers.put("java.util.Date", new SnmpDateMaker());
    }

    public SnmpVarBind make(String oid, Object value) throws MappingFailedException {
        String type = value.getClass().getName();
        Maker m = (Maker)this.makers.get(type);
        if (m == null) {
            log.warn((Object)("Value type \"" + type + "\" for OID " + oid + " encountered. Using default VarBind maker"));
            return this.defaultMaker.make(oid, value);
        }
        return m.make(oid, value);
    }

    class SnmpObjectMaker
    implements Maker {
        SnmpObjectMaker() {
        }

        public SnmpVarBind make(String oid, Object value) throws MappingFailedException {
            SnmpOctetStringMaker sMaker = new SnmpOctetStringMaker();
            return sMaker.make(oid, value.toString());
        }
    }

    class SnmpDateMaker
    implements Maker {
        SnmpDateMaker() {
        }

        public SnmpVarBind make(String oid, Object value) throws MappingFailedException {
            Date d = (Date)value;
            SnmpOctetStringMaker sMaker = new SnmpOctetStringMaker();
            return sMaker.make(oid, d.toString());
        }
    }

    class SnmpOctetStringMaker
    implements Maker {
        SnmpOctetStringMaker() {
        }

        public SnmpVarBind make(String oid, Object value) throws MappingFailedException {
            String s = (String)value;
            return new SnmpVarBind(new SnmpObjectId(oid), (SnmpSyntax)new SnmpOctetString(s.getBytes()));
        }
    }

    class SnmpCounter64Maker
    implements Maker {
        SnmpCounter64Maker() {
        }

        public SnmpVarBind make(String oid, Object value) throws MappingFailedException {
            Long l = (Long)value;
            return new SnmpVarBind(new SnmpObjectId(oid), (SnmpSyntax)new SnmpCounter64(l.longValue()));
        }
    }

    class SnmpInt32Maker
    implements Maker {
        SnmpInt32Maker() {
        }

        public SnmpVarBind make(String oid, Object value) throws MappingFailedException {
            Integer i = (Integer)value;
            return new SnmpVarBind(new SnmpObjectId(oid), (SnmpSyntax)new SnmpInt32(i));
        }
    }

    static interface Maker {
        public SnmpVarBind make(String var1, Object var2) throws MappingFailedException;
    }
}

