/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.varia.stats;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.jboss.tm.TransactionLocal;
import org.jboss.varia.stats.StatisticalItem;
import org.jboss.varia.stats.TxReport;

public class TxStatistics {
    private final Map reports = new HashMap();
    private final Set collectedItemNames = new HashSet();
    private final TransactionLocal txReport = new TransactionLocal(){

        protected Object initialValue() {
            TxReport report;
            Transaction tx = this.getTransaction();
            if (tx != null) {
                report = new TxReport();
                try {
                    tx.registerSynchronization((Synchronization)new TxSynchronization(report));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Failed to register tx synchronization: " + e.getMessage());
                }
            } else {
                report = null;
            }
            return report;
        }
    };

    public String[] getCollectedItemNames() {
        return this.collectedItemNames.toArray(new String[this.collectedItemNames.size()]);
    }

    public Iterator getReports() {
        return this.reports.values().iterator();
    }

    public synchronized void clear() {
        this.reports.clear();
        this.collectedItemNames.clear();
    }

    public synchronized void addStatisticalItem(StatisticalItem item) {
        boolean addedNew;
        TxReport report = (TxReport)this.txReport.get();
        if (report != null && (addedNew = report.addItem(item))) {
            this.collectedItemNames.add(item.getName());
        }
    }

    private synchronized void addReport(TxReport report) {
        TxReport oldReport = (TxReport)this.reports.get(report.getName());
        if (oldReport == null) {
            this.reports.put(report.getName(), report);
        } else {
            oldReport.merge(report);
        }
    }

    public TxReport getReports(String reportName) {
        return (TxReport)this.reports.get(reportName);
    }

    private class TxSynchronization
    implements Synchronization {
        private final TxReport report;

        public TxSynchronization(TxReport report) {
            this.report = report;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status != 4) {
                try {
                    TxStatistics.this.addReport(this.report);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

