/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;

public class ReadOnlyAccessFilter
implements Filter {
    private static Logger log = Logger.getLogger(ReadOnlyAccessFilter.class);
    private FilterConfig filterConfig = null;
    private String readOnlyContext;
    private Map namingMethodMap;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        if (filterConfig != null) {
            this.readOnlyContext = filterConfig.getInitParameter("readOnlyContext");
            String invokerName = filterConfig.getInitParameter("invokerName");
            try {
                MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
                ObjectName mbean = new ObjectName(invokerName);
                this.namingMethodMap = (Map)mbeanServer.getAttribute(mbean, "MethodMap");
            }
            catch (Exception e) {
                log.error((Object)"Failed to init ReadOnlyAccessFilter", (Throwable)e);
                throw new ServletException("Failed to init ReadOnlyAccessFilter", (Throwable)e);
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Principal user = httpRequest.getUserPrincipal();
        if (user == null && this.readOnlyContext != null) {
            ServletInputStream sis = request.getInputStream();
            ObjectInputStream ois = new ObjectInputStream((InputStream)sis);
            MarshalledInvocation mi = null;
            try {
                mi = (MarshalledInvocation)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new ServletException("Failed to read MarshalledInvocation", (Throwable)e);
            }
            request.setAttribute("MarshalledInvocation", (Object)mi);
            mi.setMethodMap(this.namingMethodMap);
            Method m = mi.getMethod();
            if (m != null) {
                this.validateAccess(m, mi);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public String toString() {
        if (this.filterConfig == null) {
            return "NamingAccessFilter()";
        }
        StringBuffer sb = new StringBuffer("NamingAccessFilter(");
        sb.append(this.filterConfig);
        sb.append(")");
        return sb.toString();
    }

    private void validateAccess(Method m, MarshalledInvocation mi) throws ServletException {
        String methodName;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Checking against readOnlyContext: " + this.readOnlyContext));
        }
        if (!(methodName = m.getName()).equals("lookup")) {
            throw new ServletException("Only lookups against " + this.readOnlyContext + " are allowed");
        }
        Object[] args = mi.getArguments();
        String arg = args.length > 0 ? args[0] : "";
        String name = arg instanceof String ? arg : arg.toString();
        if (trace) {
            log.trace((Object)("Checking lookup(" + name + ") against: " + this.readOnlyContext));
        }
        if (!name.startsWith(this.readOnlyContext)) {
            throw new ServletException("Lookup(" + name + ") is not under: " + this.readOnlyContext);
        }
    }
}

