/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.util.propertyeditor.PropertyEditors;

public class JMX
extends Task {
    private String serverURL = "service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi";
    private String username;
    private String password;
    private List<Operation> ops = new ArrayList<Operation>();
    private List<PropertyEditorHolder> editors = new ArrayList<PropertyEditorHolder>();
    private boolean verbose;

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setServerURL(String serverURL) {
        if (this.verbose) {
            this.log("changing server url from " + this.serverURL + " to " + serverURL);
        }
        this.serverURL = serverURL;
    }

    public void setAdapterName(String adapterName) {
        this.log("ignoring adapter name (" + adapterName + ") as its no longer used.");
    }

    public void setUsername(String username) {
        if (this.verbose) {
            this.log("will perform operation as user " + username);
        }
        this.username = username;
    }

    public void setPassword(String password) {
        if (this.verbose) {
            this.log("password has been set");
        }
        this.password = password;
    }

    public void addInvoke(Invoke invoke) {
        if (this.verbose) {
            String operation = null;
            String name = null;
            if (invoke != null && invoke.target != null) {
                name = invoke.target.getCanonicalName();
            }
            if (invoke != null && invoke.operation != null) {
                operation = invoke.operation;
            }
            this.log("invoke added for " + operation + " on " + name);
        }
        this.ops.add(invoke);
    }

    public void addSetAttribute(Setter setter) {
        if (this.verbose) {
            String name = null;
            if (setter != null && setter.target != null) {
                name = setter.target.getCanonicalName();
            }
            this.log("set attribute " + setter.attribute + " on " + name);
        }
        this.ops.add(setter);
    }

    public void addGetAttribute(Getter getter) {
        if (this.verbose) {
            String name = null;
            if (getter != null && getter.target != null) {
                name = getter.target.getCanonicalName();
            }
            this.log("get attribute " + getter.attribute + " on " + name);
        }
        this.ops.add(getter);
    }

    public void addPropertyEditor(PropertyEditorHolder peh) {
        if (this.verbose) {
            this.log("use property editor " + peh.getEditor());
        }
        this.editors.add(peh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.verbose) {
            this.log("started execute");
        }
        ClassLoader origCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                for (int i = 0; i < this.editors.size(); ++i) {
                    if (this.verbose) {
                        this.log("execute editor " + this.editors.get(i).getEditor());
                    }
                    this.editors.get(i).execute();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException("Could not register property editors: " + e);
            }
            try {
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                if (this.username != null && this.password != null) {
                    if (this.verbose) {
                        this.log("will connect with username=" + this.username);
                    }
                    String[] creds = new String[]{this.username, this.password};
                    env.put("jmx.remote.credentials", creds);
                }
                JMXServiceURL url = new JMXServiceURL(this.serverURL);
                if (this.verbose) {
                    this.log("will connect with JMXServiceURL = " + url);
                }
                JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
                MBeanServerConnection server = jmxc.getMBeanServerConnection();
                if (this.verbose) {
                    this.log("connected to server");
                }
                for (int i = 0; i < this.ops.size(); ++i) {
                    Operation op = this.ops.get(i);
                    if (this.verbose) {
                        this.log("execute operation " + op.getLogInformation());
                    }
                    Object result = op.execute(server, this);
                    if (!this.verbose || result == null) continue;
                    this.log(result.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BuildException("problem: " + e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCL);
        }
        if (this.verbose) {
            this.log("stopped execute");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyEditorHolder {
        private String type;
        private String editor;

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        private Class<?> getTypeClass() throws ClassNotFoundException {
            try {
                return Class.forName(this.type);
            }
            catch (ClassNotFoundException e) {
                try {
                    return this.getClass().getClassLoader().loadClass(this.type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Thread.currentThread().getContextClassLoader().loadClass(this.type);
                }
            }
        }

        public void setEditor(String editor) {
            this.editor = editor;
        }

        public String getEditor() {
            return this.editor;
        }

        private Class<?> getEditorClass() throws ClassNotFoundException {
            try {
                return Class.forName(this.editor);
            }
            catch (ClassNotFoundException e) {
                try {
                    return this.getClass().getClassLoader().loadClass(this.editor);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return Thread.currentThread().getContextClassLoader().loadClass(this.editor);
                }
            }
        }

        public void execute() throws ClassNotFoundException {
            PropertyEditorManager.registerEditor(this.getTypeClass(), this.getEditorClass());
        }
    }

    public static class Param {
        private String arg;
        private String type;

        public void setArg(String arg) {
            this.arg = arg;
        }

        public String getArg() {
            return this.arg;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public Object getValue() throws Exception {
            PropertyEditor editor = PropertyEditors.getEditor((String)this.type);
            editor.setAsText(this.arg);
            return editor.getValue();
        }
    }

    public static class Getter
    implements Operation {
        private ObjectName target;
        private String attribute;
        private String property;

        public void setTarget(ObjectName target) {
            this.target = target;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getLogInformation() {
            return "getting " + this.target.getCanonicalName() + ":" + this.attribute;
        }

        public Object execute(MBeanServerConnection server, Task parent) throws Exception {
            Object result = server.getAttribute(this.target, this.attribute);
            if (this.property != null && result != null) {
                parent.getProject().setProperty(this.property, result.toString());
            }
            return result;
        }
    }

    public static class Setter
    implements Operation {
        private ObjectName target;
        private String attribute;
        private Param value;

        public void setTarget(ObjectName target) {
            this.target = target;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public void setValue(Param value) {
            this.value = value;
        }

        public String getLogInformation() {
            return "setting " + this.target.getCanonicalName() + ":" + this.attribute + " to " + this.value.getArg();
        }

        public Object execute(MBeanServerConnection server, Task parent) throws Exception {
            Attribute att = new Attribute(this.attribute, this.value.getValue());
            server.setAttribute(this.target, att);
            return null;
        }
    }

    public static class Invoke
    implements Operation {
        private ObjectName target;
        private String property;
        private String operation;
        private List<Param> params = new ArrayList<Param>();

        public void setProperty(String property) {
            this.property = property;
        }

        public void setTarget(ObjectName target) {
            this.target = target;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public void addParameter(Param param) {
            this.params.add(param);
        }

        public String getLogInformation() {
            return "invoking " + this.operation;
        }

        public Object execute(MBeanServerConnection server, Task parent) throws Exception {
            int paramCount = this.params.size();
            Object[] args = new Object[paramCount];
            String[] types = new String[paramCount];
            int pos = 0;
            for (int i = 0; i < this.params.size(); ++i) {
                Param p = this.params.get(i);
                args[pos] = p.getValue();
                types[pos] = p.getType();
                ++pos;
            }
            Object result = server.invoke(this.target, this.operation, args, types);
            if (this.property != null && result != null) {
                parent.getProject().setProperty(this.property, result.toString());
            }
            return result;
        }
    }

    public static interface Operation {
        public Object execute(MBeanServerConnection var1, Task var2) throws Exception;

        public String getLogInformation();
    }
}

