/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity.sso;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import org.jboss.security.identity.sso.AuthResponse;
import org.jboss.security.identity.sso.SSOException;
import org.jboss.security.identity.sso.SSOUser;
import org.jboss.security.identity.sso.SingleSignOnProcessor;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAuthenticationQuery;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLStatement;
import org.opensaml.SAMLSubject;
import org.opensaml.provider.SecureRandomIDProvider;

public class JBossSingleSignOnProcessor
implements SingleSignOnProcessor {
    private SecureRandomIDProvider idProvider = new SecureRandomIDProvider();
    private static final String LOGIN_FAILED = "login_failed";

    public String generateAuthRequest(String username, String password) throws SSOException {
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("username is null or zero-length");
        }
        if (password == null) {
            throw new IllegalArgumentException("password is null");
        }
        try {
            String request = null;
            SAMLNameIdentifier id = new SAMLNameIdentifier();
            id.setName(username);
            id.setNameQualifier(password);
            id.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            SAMLSubject subject = new SAMLSubject();
            subject.setNameIdentifier(id);
            SAMLAuthenticationQuery query = new SAMLAuthenticationQuery(subject, "urn:oasis:names:tc:SAML:1.0:am:password");
            SAMLRequest authRequest = new SAMLRequest((SAMLQuery)query);
            request = authRequest.toString();
            return request;
        }
        catch (SAMLException sme) {
            throw new SSOException(sme);
        }
    }

    public String generateAuthResponse(String assertingParty, String username, boolean success) throws SSOException {
        if (assertingParty == null || assertingParty.length() == 0) {
            throw new IllegalArgumentException("assertingParty is null or zero-length");
        }
        if (username == null || username.length() == 0) {
            throw new IllegalArgumentException("username is null or zero-length");
        }
        try {
            String response = null;
            SAMLResponse authResponse = new SAMLResponse();
            authResponse.setId(this.idProvider.getIdentifier());
            if (success) {
                SAMLNameIdentifier id = new SAMLNameIdentifier();
                id.setName(username);
                id.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
                SAMLSubject subject = new SAMLSubject();
                subject.setNameIdentifier(id);
                String methodStr = "urn:oasis:names:tc:SAML:1.0:am:password";
                SAMLAuthenticationStatement authStatement = new SAMLAuthenticationStatement();
                authStatement.setAuthMethod(methodStr);
                authStatement.setSubject(subject);
                authStatement.setAuthInstant(new Date());
                SAMLAssertion authAssertion = new SAMLAssertion();
                authAssertion.setId(this.idProvider.getIdentifier());
                authAssertion.setIssuer(assertingParty);
                authAssertion.addStatement((SAMLStatement)authStatement);
                authResponse.addAssertion(authAssertion);
            } else {
                SAMLException loginFailed = new SAMLException(LOGIN_FAILED);
                authResponse.setStatus(loginFailed);
            }
            response = authResponse.toString();
            return response;
        }
        catch (SAMLException sme) {
            throw new SSOException(sme);
        }
    }

    public SSOUser parseAuthRequest(String request) throws SSOException {
        if (request == null || request.length() == 0) {
            throw new IllegalArgumentException("request is null or zero-length");
        }
        ByteArrayInputStream bis = null;
        try {
            SSOUser user = null;
            bis = new ByteArrayInputStream(request.getBytes());
            SAMLRequest authRequest = new SAMLRequest((InputStream)bis);
            SAMLAuthenticationQuery query = (SAMLAuthenticationQuery)authRequest.getQuery();
            SAMLSubject subject = query.getSubject();
            SAMLNameIdentifier id = subject.getNameIdentifier();
            String username = id.getName();
            String password = id.getNameQualifier();
            SSOUser sSOUser = user = new SSOUser(username, password);
            return sSOUser;
        }
        catch (SAMLException sme) {
            throw new SSOException(sme);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public AuthResponse parseAuthResponse(String resp) throws SSOException {
        if (resp == null || resp.length() == 0) {
            throw new IllegalArgumentException("response is null or zero-length");
        }
        AuthResponse authResponse = null;
        ByteArrayInputStream bis = null;
        boolean success = false;
        String assertToken = null;
        String assertingParty = null;
        String username = null;
        try {
            AuthResponse authAssertion;
            bis = new ByteArrayInputStream(resp.getBytes());
            SAMLResponse response = new SAMLResponse((InputStream)bis);
            Iterator assertions = response.getAssertions();
            if (assertions != null && assertions.hasNext()) {
                success = true;
                authAssertion = (SAMLAssertion)assertions.next();
                assertToken = authAssertion.getId();
                assertingParty = authAssertion.getIssuer();
                SAMLAuthenticationStatement authStatement = (SAMLAuthenticationStatement)authAssertion.getStatements().next();
                username = authStatement.getSubject().getNameIdentifier().getName();
                SSOUser user = new SSOUser(username, null);
                authResponse = new AuthResponse(assertingParty, assertToken, user, success);
            }
            authAssertion = authResponse;
            return authAssertion;
        }
        catch (SAMLException sme) {
            if (sme.getMessage().equals(LOGIN_FAILED)) {
                success = false;
                AuthResponse authResponse2 = authResponse = new AuthResponse(assertingParty, assertToken, null, success);
                return authResponse2;
            }
            throw new SSOException(sme);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

