/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.WebservicesMetaData;
import org.jboss.metadata.javaee.spec.PortComponent;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;
import org.jboss.wsf.spi.metadata.j2ee.MDBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.SLSBMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBArchiveMetaDataAdapterEJB21 {
    private static Logger log = Logger.getLogger(EJBArchiveMetaDataAdapterEJB21.class);

    public EJBArchiveMetaData buildMetaData(Deployment dep, DeploymentUnit unit) {
        JBossMetaData jbossMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        dep.addAttachment(JBossMetaData.class, (Object)jbossMetaData);
        EJBArchiveMetaData ejbMetaData = new EJBArchiveMetaData();
        this.buildEnterpriseBeansMetaData(ejbMetaData, jbossMetaData);
        this.buildWebservicesMetaData(ejbMetaData, jbossMetaData);
        ejbMetaData.setSecurityDomain(jbossMetaData.getSecurityDomain());
        return ejbMetaData;
    }

    private void buildEnterpriseBeansMetaData(EJBArchiveMetaData ejbMetaData, JBossMetaData jbossMetaData) {
        ArrayList<EJBMetaData> targetBeans = new ArrayList<EJBMetaData>();
        JBossEnterpriseBeansMetaData sourceBeans = jbossMetaData.getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData bmd : sourceBeans) {
            this.buildBeanMetaData(targetBeans, bmd);
        }
        ejbMetaData.setEnterpriseBeans(targetBeans);
    }

    private void buildWebservicesMetaData(EJBArchiveMetaData ejbMetaData, JBossMetaData jbossMetaData) {
        WebservicesMetaData webservices = jbossMetaData.getWebservices();
        if (webservices != null) {
            String contextRoot = webservices.getContextRoot();
            ejbMetaData.setWebServiceContextRoot(contextRoot);
            ejbMetaData.setPublishLocationAdapter(this.getPublishLocationAdpater(webservices));
            WebserviceDescriptionsMetaData wsDescriptions = webservices.getWebserviceDescriptions();
            if (wsDescriptions != null) {
                if (wsDescriptions.size() > 1) {
                    log.warn((Object)"Multiple <webservice-description> elements not supported");
                }
                if (wsDescriptions.size() > 0) {
                    WebserviceDescriptionMetaData wsd = (WebserviceDescriptionMetaData)wsDescriptions.iterator().next();
                    ejbMetaData.setConfigName(wsd.getConfigName());
                    ejbMetaData.setConfigFile(wsd.getConfigFile());
                }
            }
        }
    }

    private EJBArchiveMetaData.PublishLocationAdapter getPublishLocationAdpater(final WebservicesMetaData wsMetaData) {
        return new EJBArchiveMetaData.PublishLocationAdapter(){

            public String getWsdlPublishLocationByName(String name) {
                String wsdlPublishLocation = null;
                WebserviceDescriptionsMetaData wsDescriptions = wsMetaData.getWebserviceDescriptions();
                if (wsDescriptions != null && wsDescriptions.get(name) != null) {
                    WebserviceDescriptionMetaData wsdMetaData = (WebserviceDescriptionMetaData)wsDescriptions.get(name);
                    wsdlPublishLocation = wsdMetaData.getWsdlPublishLocation();
                }
                return wsdlPublishLocation;
            }
        };
    }

    private EJBMetaData buildBeanMetaData(List<EJBMetaData> ejbBeans, JBossEnterpriseBeanMetaData jbossBeansMetaData) {
        SLSBMetaData targetBean = null;
        if (jbossBeansMetaData.isSession()) {
            targetBean = new SLSBMetaData();
            JBossSessionBeanMetaData jbossSessionBean = (JBossSessionBeanMetaData)jbossBeansMetaData;
            targetBean.setEjbName(jbossSessionBean.getEjbName());
            targetBean.setEjbClass(jbossSessionBean.getEjbClass());
            targetBean.setServiceEndpointInterface(jbossSessionBean.getServiceEndpoint());
            targetBean.setHome(jbossSessionBean.getHome());
            targetBean.setLocalHome(jbossSessionBean.getLocalHome());
            targetBean.setJndiName(jbossSessionBean.determineJndiName());
            targetBean.setLocalJndiName(jbossBeansMetaData.determineLocalJndiName());
            PortComponent pcmd = jbossSessionBean.getPortComponent();
            if (pcmd != null) {
                targetBean.setPortComponentName(pcmd.getPortComponentName());
                targetBean.setPortComponentURI(pcmd.getPortComponentURI());
                EJBSecurityMetaData smd = new EJBSecurityMetaData();
                smd.setAuthMethod(pcmd.getAuthMethod());
                smd.setTransportGuarantee(pcmd.getTransportGuarantee());
                smd.setSecureWSDLAccess(Boolean.valueOf(pcmd.getSecureWSDLAccess()));
                targetBean.setSecurityMetaData(smd);
            }
        } else if (jbossBeansMetaData.isMessageDriven()) {
            targetBean = new MDBMetaData();
            JBossMessageDrivenBeanMetaData jbossMessageBean = (JBossMessageDrivenBeanMetaData)jbossBeansMetaData;
            targetBean.setEjbName(jbossMessageBean.getEjbName());
            targetBean.setEjbClass(jbossMessageBean.getEjbClass());
            targetBean.setLocalJndiName(jbossBeansMetaData.getLocalJndiName());
            ((MDBMetaData)targetBean).setDestinationJndiName(jbossMessageBean.getDestinationJndiName());
        }
        if (targetBean != null) {
            ejbBeans.add((EJBMetaData)targetBean);
        }
        return targetBean;
    }
}

