/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.JSEArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.JSESecurityMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSEArchiveMetaDataAdapter {
    private static Logger log = Logger.getLogger(JSEArchiveMetaDataAdapter.class);

    public JSEArchiveMetaData buildMetaData(Deployment dep, DeploymentUnit unit) {
        ModuleMetaData module;
        JBossAppMetaData appmd;
        String contextRoot = null;
        JBossWebMetaData jbossWebMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        dep.addAttachment(JBossWebMetaData.class, (Object)jbossWebMetaData);
        if (unit.getParent() != null && (appmd = (JBossAppMetaData)unit.getParent().getAttachment(JBossAppMetaData.class)) != null && (module = appmd.getModule(dep.getSimpleName())) != null) {
            WebModuleMetaData web = (WebModuleMetaData)module.getValue();
            contextRoot = web.getContextRoot();
        }
        if (contextRoot == null) {
            contextRoot = jbossWebMetaData.getContextRoot();
        }
        JSEArchiveMetaData umd = new JSEArchiveMetaData();
        umd.setContextRoot(contextRoot);
        umd.setServletMappings(this.getServletMappings(jbossWebMetaData));
        umd.setServletClassNames(this.getServletClassMap(jbossWebMetaData));
        umd.setSecurityDomain(jbossWebMetaData.getSecurityDomain());
        umd.setPublishLocationAdapter(this.getPublishLocationAdpater(jbossWebMetaData));
        umd.setSecurityMetaData(this.getSecurityMetaData(jbossWebMetaData.getSecurityContraints()));
        this.setConfigNameAndFile(umd, jbossWebMetaData);
        return umd;
    }

    private void setConfigNameAndFile(JSEArchiveMetaData umd, JBossWebMetaData jbossWebMetaData) {
        List contextParams;
        String configName = null;
        String configFile = null;
        WebserviceDescriptionsMetaData wsDescriptions = jbossWebMetaData.getWebserviceDescriptions();
        if (wsDescriptions != null && wsDescriptions.size() > 1) {
            log.warn((Object)"Multiple <webservice-description> elements not supported");
        }
        if (wsDescriptions != null && wsDescriptions.size() > 0) {
            WebserviceDescriptionMetaData wsd = (WebserviceDescriptionMetaData)wsDescriptions.iterator().next();
            configName = wsd.getConfigName();
            configFile = wsd.getConfigFile();
        }
        if ((contextParams = jbossWebMetaData.getContextParams()) != null) {
            for (ParamValueMetaData ctxParam : contextParams) {
                if (ctxParam.getParamName().equals("jbossws-config-name")) {
                    configName = ctxParam.getParamValue();
                }
                if (!ctxParam.getParamName().equals("jbossws-config-file")) continue;
                configFile = ctxParam.getParamValue();
            }
        }
        umd.setConfigName(configName);
        umd.setConfigFile(configFile);
    }

    private JSEArchiveMetaData.PublishLocationAdapter getPublishLocationAdpater(final JBossWebMetaData wmd) {
        return new JSEArchiveMetaData.PublishLocationAdapter(){

            public String getWsdlPublishLocationByName(String name) {
                WebserviceDescriptionsMetaData wsdmd = wmd.getWebserviceDescriptions();
                WebserviceDescriptionMetaData wsmd = (WebserviceDescriptionMetaData)wsdmd.get(name);
                String location = null;
                if (wsmd != null) {
                    location = wsmd.getWsdlPublishLocation();
                }
                return location;
            }
        };
    }

    protected List<JSESecurityMetaData> getSecurityMetaData(List<SecurityConstraintMetaData> securityConstraints) {
        ArrayList<JSESecurityMetaData> unifiedsecurityMetaData = new ArrayList<JSESecurityMetaData>();
        if (securityConstraints != null) {
            for (SecurityConstraintMetaData securityMetaData : securityConstraints) {
                JSESecurityMetaData current = new JSESecurityMetaData();
                unifiedsecurityMetaData.add(current);
                current.setTransportGuarantee(securityMetaData.getTransportGuarantee().name());
                WebResourceCollectionsMetaData resources = securityMetaData.getResourceCollections();
                for (WebResourceCollectionMetaData webResource : resources) {
                    JSESecurityMetaData.JSEResourceCollection currentResource = current.addWebResource(webResource.getName());
                    for (String currentPattern : webResource.getUrlPatterns()) {
                        currentResource.addPattern(currentPattern);
                    }
                }
            }
        }
        return unifiedsecurityMetaData;
    }

    private Map<String, String> getServletMappings(JBossWebMetaData wmd) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        List smappings = wmd.getServletMappings();
        if (smappings != null) {
            for (ServletMappingMetaData mapping : smappings) {
                mappings.put(mapping.getServletName(), (String)mapping.getUrlPatterns().get(0));
            }
        }
        return mappings;
    }

    private Map<String, String> getServletClassMap(JBossWebMetaData wmd) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        JBossServletsMetaData servlets = wmd.getServlets();
        if (servlets != null) {
            for (JBossServletMetaData servlet : servlets) {
                if (servlet.getServletClass() == null || servlet.getServletClass().length() == 0) continue;
                mappings.put(servlet.getName(), servlet.getServletClass());
            }
        }
        return mappings;
    }
}

