/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.transport;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.AuthConstraintMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.metadata.web.spec.SecurityConstraintMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.TransportGuaranteeType;
import org.jboss.metadata.web.spec.UserDataConstraintMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionMetaData;
import org.jboss.metadata.web.spec.WebResourceCollectionsMetaData;
import org.jboss.wsf.container.jboss50.deployment.tomcat.SecurityHandler;
import org.jboss.wsf.spi.annotation.WebContext;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.WSFDeploymentException;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBSecurityMetaData;

public class WebAppGenerator {
    private SecurityHandler securityHandlerEJB21;
    private SecurityHandler securityHandlerEJB3;

    public void setSecurityHandlerEJB21(SecurityHandler handler) {
        this.securityHandlerEJB21 = handler;
    }

    public void setSecurityHandlerEJB3(SecurityHandler handler) {
        this.securityHandlerEJB3 = handler;
    }

    public JBossWebMetaData create(Deployment dep) {
        JBossWebMetaData jbwmd = null;
        String typeStr = dep.getType().toString();
        if (typeStr.endsWith("EJB21")) {
            jbwmd = this.generatWebDeployment((ArchiveDeployment)dep, this.securityHandlerEJB21);
            dep.addAttachment(JBossWebMetaData.class, (Object)jbwmd);
        } else if (typeStr.endsWith("EJB3")) {
            jbwmd = this.generatWebDeployment((ArchiveDeployment)dep, this.securityHandlerEJB3);
            dep.addAttachment(JBossWebMetaData.class, (Object)jbwmd);
        } else {
            jbwmd = this.generatWebDeployment((ArchiveDeployment)dep, null);
            dep.addAttachment(JBossWebMetaData.class, (Object)jbwmd);
        }
        return jbwmd;
    }

    protected JBossWebMetaData generatWebDeployment(ArchiveDeployment dep, SecurityHandler securityHandler) {
        JBossWebMetaData jbwmd = new JBossWebMetaData();
        this.createWebAppDescriptor((Deployment)dep, jbwmd, securityHandler);
        this.createJBossWebAppDescriptor((Deployment)dep, jbwmd, securityHandler);
        return jbwmd;
    }

    protected void createWebAppDescriptor(Deployment dep, JBossWebMetaData jbwmd, SecurityHandler securityHandler) {
        JBossServletsMetaData servlets = jbwmd.getServlets();
        for (Endpoint ep : dep.getService().getEndpoints()) {
            JBossServletMetaData servlet = new JBossServletMetaData();
            servlet.setServletName(ep.getShortName());
            servlet.setServletClass(ep.getTargetBeanName());
            servlets.add((MappableMetaData)servlet);
        }
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ArrayList<ServletMappingMetaData> servletMappings = jbwmd.getServletMappings();
            if (servletMappings == null) {
                servletMappings = new ArrayList<ServletMappingMetaData>();
                jbwmd.setServletMappings(servletMappings);
            }
            ServletMappingMetaData servletMapping = new ServletMappingMetaData();
            servletMapping.setServletName(ep.getShortName());
            servletMapping.setUrlPatterns(Arrays.asList(ep.getURLPattern()));
            servletMappings.add(servletMapping);
        }
        String authMethod = null;
        for (Endpoint ep : dep.getService().getEndpoints()) {
            EJBMetaData bmd;
            EJBSecurityMetaData smd;
            EJBArchiveMetaData appMetaData;
            String ejbName = ep.getShortName();
            Boolean secureWSDLAccess = null;
            String transportGuarantee = null;
            String beanAuthMethod = null;
            WebContext anWebContext = ep.getTargetBeanClass().getAnnotation(WebContext.class);
            if (anWebContext != null) {
                if (anWebContext.authMethod().length() > 0) {
                    beanAuthMethod = anWebContext.authMethod();
                }
                if (anWebContext.transportGuarantee().length() > 0) {
                    transportGuarantee = anWebContext.transportGuarantee();
                }
                if (anWebContext.secureWSDLAccess()) {
                    secureWSDLAccess = anWebContext.secureWSDLAccess();
                }
            }
            if ((appMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class)) != null && appMetaData.getBeanByEjbName(ejbName) != null && (smd = (bmd = appMetaData.getBeanByEjbName(ejbName)).getSecurityMetaData()) != null) {
                beanAuthMethod = smd.getAuthMethod();
                transportGuarantee = smd.getTransportGuarantee();
                secureWSDLAccess = smd.getSecureWSDLAccess();
            }
            if (beanAuthMethod == null && transportGuarantee == null) continue;
            ArrayList<SecurityConstraintMetaData> securityContraints = jbwmd.getSecurityContraints();
            if (securityContraints == null) {
                securityContraints = new ArrayList<SecurityConstraintMetaData>();
                jbwmd.setSecurityContraints(securityContraints);
            }
            SecurityConstraintMetaData securityConstraint = new SecurityConstraintMetaData();
            securityContraints.add(securityConstraint);
            WebResourceCollectionsMetaData resourceCollections = securityConstraint.getResourceCollections();
            if (resourceCollections == null) {
                resourceCollections = new WebResourceCollectionsMetaData();
                securityConstraint.setResourceCollections(resourceCollections);
            }
            WebResourceCollectionMetaData resourceCollection = new WebResourceCollectionMetaData();
            resourceCollections.add((Object)resourceCollection);
            resourceCollection.setWebResourceName(ejbName);
            resourceCollection.setUrlPatterns(Arrays.asList(ep.getURLPattern()));
            ArrayList<String> httpMethods = new ArrayList<String>();
            resourceCollection.setHttpMethods(httpMethods);
            if (Boolean.TRUE.equals(secureWSDLAccess)) {
                httpMethods.add("GET");
            }
            httpMethods.add("POST");
            if (beanAuthMethod != null) {
                if (authMethod == null) {
                    authMethod = beanAuthMethod;
                }
                AuthConstraintMetaData authConstraint = new AuthConstraintMetaData();
                authConstraint.setRoleNames(Arrays.asList("*"));
                securityConstraint.setAuthConstraint(authConstraint);
            }
            if (transportGuarantee == null) continue;
            UserDataConstraintMetaData userDataConstraint = new UserDataConstraintMetaData();
            userDataConstraint.setTransportGuarantee(TransportGuaranteeType.valueOf((String)transportGuarantee));
            securityConstraint.setUserDataConstraint(userDataConstraint);
        }
        if (authMethod != null && securityHandler != null) {
            LoginConfigMetaData loginConfig = jbwmd.getLoginConfig();
            if (loginConfig == null) {
                loginConfig = new LoginConfigMetaData();
                jbwmd.setLoginConfig(loginConfig);
            }
            loginConfig.setAuthMethod(authMethod);
            loginConfig.setRealmName("EJBServiceEndpointServlet Realm");
            securityHandler.addSecurityRoles(jbwmd, dep);
        }
    }

    protected void createJBossWebAppDescriptor(Deployment dep, JBossWebMetaData jbwmd, SecurityHandler securityHandler) {
        String contextRoot;
        if (securityHandler != null) {
            securityHandler.addSecurityDomain(jbwmd, dep);
        }
        if ((contextRoot = dep.getService().getContextRoot()) == null) {
            throw new WSFDeploymentException("Cannot obtain context root");
        }
        jbwmd.setContextRoot(contextRoot);
    }
}

