/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jmx.adaptor.snmp.agent;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jmx.adaptor.snmp.agent.MappingFailedException;
import org.jboss.logging.Logger;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class SnmpVarBindFactory {
    private static final Logger log = Logger.getLogger(SnmpVarBindFactory.class);
    private Map<String, Maker> makers = new HashMap<String, Maker>();
    private final Maker defaultMaker = new SnmpObjectMaker();

    public SnmpVarBindFactory() {
        this.makers.put("java.lang.Boolean", new SnmpBooleanMaker());
        this.makers.put("java.lang.String", new SnmpOctetStringMaker());
        this.makers.put("java.lang.Integer", new SnmpInt32Maker());
        this.makers.put("java.lang.Long", new SnmpLongMaker());
        this.makers.put("java.math.BigInteger", new SnmpCounter64Maker());
        this.makers.put("java.util.Date", new SnmpDateMaker());
    }

    public VariableBinding make(String oid, Object value) throws MappingFailedException {
        String type = value.getClass().getName();
        Maker m = this.makers.get(type);
        if (m == null) {
            log.warn((Object)("Value type \"" + type + "\" for OID " + oid + " encountered. Using default VarBind maker"));
            return this.defaultMaker.make(oid, value);
        }
        return m.make(oid, value);
    }

    class SnmpObjectMaker
    implements Maker {
        SnmpObjectMaker() {
        }

        public VariableBinding make(String oid, Object value) throws MappingFailedException {
            SnmpOctetStringMaker sMaker = new SnmpOctetStringMaker();
            return sMaker.make(oid, value.toString());
        }
    }

    class SnmpDateMaker
    implements Maker {
        SnmpDateMaker() {
        }

        public VariableBinding make(String oid, Object value) throws MappingFailedException {
            Date d = (Date)value;
            SnmpOctetStringMaker sMaker = new SnmpOctetStringMaker();
            return sMaker.make(oid, d.toString());
        }
    }

    class SnmpOctetStringMaker
    implements Maker {
        SnmpOctetStringMaker() {
        }

        public VariableBinding make(String oid, Object value) throws MappingFailedException {
            String s = (String)value;
            return new VariableBinding(new OID(oid), (Variable)new OctetString(s.getBytes()));
        }
    }

    class SnmpCounter64Maker
    implements Maker {
        SnmpCounter64Maker() {
        }

        public VariableBinding make(String oid, Object value) throws MappingFailedException {
            Long l = (Long)value;
            return new VariableBinding(new OID(oid), (Variable)new Counter64(l.longValue()));
        }
    }

    class SnmpLongMaker
    implements Maker {
        SnmpLongMaker() {
        }

        public VariableBinding make(String oid, Object value) throws MappingFailedException {
            Long l = (Long)value;
            return new VariableBinding(new OID(oid), (Variable)new OctetString(l.toString()));
        }
    }

    class SnmpBooleanMaker
    implements Maker {
        SnmpBooleanMaker() {
        }

        public VariableBinding make(String oid, Object value) throws MappingFailedException {
            Boolean b = (Boolean)value;
            Integer32 result = b != false ? new Integer32(1) : new Integer32(0);
            return new VariableBinding(new OID(oid), (Variable)result);
        }
    }

    class SnmpInt32Maker
    implements Maker {
        SnmpInt32Maker() {
        }

        public VariableBinding make(String oid, Object value) throws MappingFailedException {
            Integer i = (Integer)value;
            return new VariableBinding(new OID(oid), (Variable)new Integer32(i.intValue()));
        }
    }

    static interface Maker {
        public VariableBinding make(String var1, Object var2) throws MappingFailedException;
    }
}

