/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.husky.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Util {
    public static Object loadInstance(String className, Properties props) {
        Class<?> instanceClass = Util.loadClass(className);
        Object instance = null;
        try {
            Constructor<?> ctor = instanceClass.getConstructor(Properties.class);
            instance = ctor.newInstance(props);
        }
        catch (NoSuchMethodException ex) {
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot load: " + className, ex);
        }
        if (instance == null) {
            try {
                instance = instanceClass.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot load: " + className, ex);
            }
        }
        return instance;
    }

    public static Class<?> loadClass(String className) {
        Class<?> instanceClass;
        try {
            instanceClass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Cannot load: " + className, ex);
        }
        return instanceClass;
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[1024];
        int read = in.read(bytes);
        while (read > 0) {
            out.write(bytes, 0, read);
            read = in.read(bytes);
        }
    }
}

