/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.tracker.ContextTracker;
import org.jboss.dependency.spi.tracker.ContextTracking;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.ControllerContextHandle;
import org.jboss.osgi.framework.bundle.MDRUtils;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiServiceState;
import org.jboss.osgi.framework.plugins.ServiceManagerPlugin;
import org.jboss.osgi.framework.util.KernelUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

class GenericServiceReferenceWrapper
extends ControllerContextHandle
implements ServiceReference {
    private AbstractKernelControllerContext context;
    private AbstractBundleState bundleState;

    public GenericServiceReferenceWrapper(AbstractBundleState bundleState, AbstractKernelControllerContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        this.context = context;
        this.bundleState = bundleState;
        Dictionary<String, Object> properties = MDRUtils.getProperties((ControllerContext)context);
        if (properties.get("service.id") == null) {
            Long serviceId = OSGiServiceState.getNextServiceId();
            properties.put("service.id", serviceId);
        }
        if (properties.get("objectClass") == null) {
            String[] objectClass = MDRUtils.getClasses((ControllerContext)context);
            if (objectClass == null) {
                BeanMetaData bmd = context.getBeanMetaData();
                objectClass = new String[]{bmd.getBean()};
            }
            properties.put("objectClass", objectClass);
        }
        if (properties.get("service.ranking") == null) {
            properties.put("service.ranking", Integer.MIN_VALUE);
        }
    }

    @Override
    ControllerContext getContext() {
        return this.context;
    }

    public Object getProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Null property key");
        }
        Object value = MDRUtils.getProperty((ControllerContext)this.context, key, Object.class);
        return value;
    }

    public String[] getPropertyKeys() {
        Dictionary<String, Object> dictionary = MDRUtils.getProperties((ControllerContext)this.context);
        String[] keys = new String[dictionary.size()];
        int i = 0;
        Enumeration<String> e = dictionary.keys();
        while (e.hasMoreElements()) {
            keys[i++] = e.nextElement();
        }
        return keys;
    }

    public Bundle getBundle() {
        if (KernelUtils.isUnregistered((ControllerContext)this.context)) {
            return null;
        }
        return this.bundleState.getBundleInternal();
    }

    public Bundle[] getUsingBundles() {
        if (this.context instanceof ContextTracking) {
            AbstractKernelControllerContext tracking = this.context;
            ContextTracker ct = tracking.getContextTracker();
            if (ct == null) {
                return null;
            }
            OSGiBundleManager manager = this.bundleState.getBundleManager();
            ServiceManagerPlugin plugin = manager.getPlugin(ServiceManagerPlugin.class);
            Set users = ct.getUsers((ControllerContext)this.context);
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            for (Object user : users) {
                AbstractBundleState abs = plugin.getBundleForUser(user);
                bundles.add(abs.getBundleInternal());
            }
            if (!bundles.isEmpty()) {
                return bundles.toArray(new Bundle[bundles.size()]);
            }
        }
        return null;
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        AbstractBundleState targetBundle = AbstractBundleState.assertBundleState(bundle);
        return MDRUtils.isAssignableTo((ControllerContext)this.context, this.bundleState, targetBundle, className);
    }

    public int compareTo(Object obj) {
        return MDRUtils.compareTo((ControllerContext)this.context, obj);
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GenericServiceReferenceWrapper)) {
            return false;
        }
        GenericServiceReferenceWrapper other = (GenericServiceReferenceWrapper)obj;
        return this.context == other.context;
    }

    public String toString() {
        return this.context.toString();
    }
}

