/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import org.jboss.dependency.spi.tracker.ContextTracker;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.qualifier.QualifierMatcher;
import org.jboss.kernel.spi.qualifier.QualifierMatchers;
import org.jboss.kernel.spi.qualifier.QualifierParser;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.retrieval.MetaDataRetrievalFactory;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.osgi.framework.bundle.FilterParserAndMatcher;
import org.jboss.osgi.framework.bundle.InstanceMetaDataRetrievalFactory;
import org.jboss.osgi.framework.bundle.KernelDictionaryFactory;
import org.jboss.osgi.framework.bundle.OSGiServiceStateDictionaryFactory;

public class MetaDataRetrievalService {
    private Kernel kernel;
    private ContextTracker systemTracker;
    private MetaDataRetrievalFactory factory;
    private ContextTracker previousTracker;

    public MetaDataRetrievalService(Kernel kernel, ContextTracker systemTracker) {
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        if (systemTracker == null) {
            throw new IllegalArgumentException("Null system tracker");
        }
        this.kernel = kernel;
        this.systemTracker = systemTracker;
    }

    public void start() {
        this.applyMDRUsage(true);
    }

    public void stop() {
        this.applyMDRUsage(false);
    }

    private void applyMDRUsage(boolean register) {
        MutableMetaDataRepository repository = this.kernel.getMetaDataRepository().getMetaDataRepository();
        MetaDataRetrieval retrieval = repository.getMetaDataRetrieval(ScopeKey.DEFAULT_SCOPE);
        if (register && retrieval == null) {
            retrieval = new MemoryMetaDataLoader(ScopeKey.DEFAULT_SCOPE);
            repository.addMetaDataRetrieval(retrieval);
        }
        if (retrieval != null && retrieval instanceof MutableMetaData) {
            MutableMetaData mmd = (MutableMetaData)retrieval;
            if (register) {
                this.previousTracker = (ContextTracker)mmd.addMetaData((Object)this.systemTracker, ContextTracker.class);
            } else if (this.previousTracker == null) {
                mmd.removeMetaData(ContextTracker.class);
                if (retrieval.isEmpty()) {
                    repository.removeMetaDataRetrieval(retrieval.getScope());
                }
            } else {
                mmd.addMetaData((Object)this.previousTracker, ContextTracker.class);
            }
        }
        FilterParserAndMatcher fpm = FilterParserAndMatcher.INSTANCE;
        QualifierMatchers matchers = QualifierMatchers.getInstance();
        if (register) {
            matchers.addParser((QualifierParser)fpm);
            matchers.addMatcher((QualifierMatcher)fpm);
            MetaDataRetrievalFactory mdrFactory = this.getMetaDataRetrievalFactory();
            repository.addMetaDataRetrievalFactory(CommonLevels.INSTANCE, mdrFactory);
        } else {
            repository.removeMetaDataRetrievalFactory(CommonLevels.INSTANCE);
            matchers.removeParser(fpm.getHandledContent());
            matchers.removeMatcher(fpm.getHandledType());
        }
    }

    private MetaDataRetrievalFactory getMetaDataRetrievalFactory() {
        MetaDataRetrievalFactory mdrFactory = this.factory;
        if (mdrFactory == null) {
            InstanceMetaDataRetrievalFactory imdrf = new InstanceMetaDataRetrievalFactory(this.kernel);
            imdrf.addFactory(new OSGiServiceStateDictionaryFactory());
            imdrf.addFactory(new KernelDictionaryFactory(this.kernel.getConfigurator()));
            mdrFactory = imdrf;
        }
        return mdrFactory;
    }

    public void setFactory(MetaDataRetrievalFactory factory) {
        this.factory = factory;
    }
}

