/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiFragmentState;
import org.jboss.osgi.framework.classloading.OSGiClassLoadingMetaData;
import org.jboss.osgi.framework.metadata.OSGiMetaData;
import org.jboss.osgi.framework.metadata.internal.AbstractVersionRange;
import org.jboss.osgi.framework.plugins.ServiceManagerPlugin;
import org.jboss.osgi.framework.plugins.StartLevelPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class OSGiBundleState
extends DeployedBundleState {
    private List<OSGiFragmentState> attachedFragments = new CopyOnWriteArrayList<OSGiFragmentState>();
    private boolean persistentlyStarted = false;
    private int startLevel = -1;

    public OSGiBundleState(OSGiBundleManager bundleManager, DeploymentUnit unit) {
        super(bundleManager, unit);
    }

    private void initializeStartLevel() {
        if (this.startLevel == -1) {
            int sl = this.getOSGiMetaData().getInitialStartLevel();
            if (sl != -1) {
                this.startLevel = sl;
            } else {
                StartLevelPlugin slp = this.getBundleManager().getOptionalPlugin(StartLevelPlugin.class);
                if (slp != null) {
                    this.startLevel = slp.getInitialBundleStartLevel();
                }
            }
        }
    }

    public static OSGiBundleState assertBundleState(Bundle bundle) {
        if (!((bundle = AbstractBundleState.assertBundleState(bundle)) instanceof OSGiBundleState)) {
            throw new IllegalArgumentException("Not an OSGiBundleState: " + bundle);
        }
        return (OSGiBundleState)bundle;
    }

    public List<OSGiFragmentState> getAttachedFragments() {
        return Collections.unmodifiableList(this.attachedFragments);
    }

    public boolean isFragmentAttachable(OSGiFragmentState fragState) {
        String hostName = this.getSymbolicName();
        Version hostVersion = this.getVersion();
        DeploymentUnit fragUnit = fragState.getDeploymentUnit();
        OSGiClassLoadingMetaData fragMetaData = (OSGiClassLoadingMetaData)((Object)fragUnit.getAttachment(ClassLoadingMetaData.class));
        OSGiClassLoadingMetaData.FragmentHostMetaData fragHost = fragMetaData.getFragmentHost();
        if (!hostName.equals(fragHost.getSymbolicName())) {
            return false;
        }
        AbstractVersionRange versionRange = fragHost.getVersionRange();
        return versionRange == null || versionRange.isInRange(hostVersion);
    }

    public void attachFragment(OSGiFragmentState fragmentState) {
        DeploymentUnit unit = this.getDeploymentUnit();
        OSGiClassLoadingMetaData clMetaData = (OSGiClassLoadingMetaData)((Object)unit.getAttachment(ClassLoadingMetaData.class));
        if (clMetaData == null) {
            throw new IllegalStateException("Cannot obtain ClassLoadingMetaData for: " + (Object)((Object)this));
        }
        DeploymentUnit fragUnit = fragmentState.getDeploymentUnit();
        OSGiClassLoadingMetaData fragMetaData = (OSGiClassLoadingMetaData)((Object)fragUnit.getAttachment(ClassLoadingMetaData.class));
        if (fragMetaData == null) {
            throw new IllegalStateException("Cannot obtain ClassLoadingMetaData for: " + (Object)((Object)fragmentState));
        }
        this.log.debug((Object)("Attach " + (Object)((Object)fragmentState) + " -> " + (Object)((Object)this)));
        this.attachedFragments.add(fragmentState);
        fragmentState.setFragmentHost(this);
        clMetaData.attachClassLoadingMetaData(fragMetaData);
    }

    @Override
    public boolean isFragment() {
        return false;
    }

    @Override
    public boolean isPersistentlyStarted() {
        return this.persistentlyStarted;
    }

    public void setPersistentlyStarted(boolean b) {
        this.persistentlyStarted = b;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int sl) {
        this.startLevel = sl;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        this.checkInstalled();
        this.checkAdminPermission("class");
        if (this.getState() == 2) {
            this.getBundleManager().resolveBundle(null);
            if (this.getState() == 2) {
                throw new ClassNotFoundException("Cannot load class: " + name);
            }
        }
        ClassLoader classLoader = this.getDeploymentUnit().getClassLoader();
        Class<?> clazz = classLoader.loadClass(name);
        return clazz;
    }

    public URL getResource(String name) {
        this.checkInstalled();
        if (this.noAdminPermission("resource")) {
            return null;
        }
        if (!this.getBundleManager().resolveBundle(this)) {
            return this.getDeploymentUnit().getResourceLoader().getResource(name);
        }
        ClassLoader classLoader = this.getDeploymentUnit().getClassLoader();
        return classLoader.getResource(name);
    }

    public Enumeration getResources(String name) throws IOException {
        this.checkInstalled();
        if (this.noAdminPermission("resource")) {
            return null;
        }
        if (!this.getBundleManager().resolveBundle(this)) {
            return this.getDeploymentUnit().getResourceLoader().getResources(name);
        }
        ClassLoader classLoader = this.getDeploymentUnit().getClassLoader();
        return classLoader.getResources(name);
    }

    @Override
    URL getLocalizationEntry(String entryPath) {
        URL entryURL;
        block1: {
            OSGiFragmentState frag;
            entryURL = this.getEntryInternal(entryPath);
            if (entryURL != null) break block1;
            Iterator<OSGiFragmentState> i$ = this.getAttachedFragments().iterator();
            while (i$.hasNext() && (entryURL = (frag = i$.next()).getEntryInternal(entryPath)) == null) {
            }
        }
        return entryURL;
    }

    public void start(int options) throws BundleException {
        StartLevelPlugin sls;
        this.checkInstalled();
        this.checkAdminPermission("execute");
        this.initializeStartLevel();
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(true);
        }
        if (this.isPersistentlyStarted() && ((sls = this.getBundleManager().getOptionalPlugin(StartLevelPlugin.class)) == null || sls.getStartLevel() >= this.getStartLevel())) {
            this.getBundleManager().startBundle(this);
        }
    }

    public void stop(int options) throws BundleException {
        this.checkInstalled();
        this.checkAdminPermission("execute");
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(false);
        }
        this.getBundleManager().stopBundle(this);
    }

    public void startInternal() throws BundleException {
        this.createBundleContext();
        this.changeState(8);
        try {
            OSGiMetaData osgiMetaData = this.getOSGiMetaData();
            if (osgiMetaData == null) {
                throw new IllegalStateException("Cannot obtain OSGi meta data");
            }
            String bundleActivatorClassName = osgiMetaData.getBundleActivator();
            if (bundleActivatorClassName != null) {
                Object result = this.loadClass(bundleActivatorClassName).newInstance();
                if (!(result instanceof BundleActivator)) {
                    throw new BundleException(bundleActivatorClassName + " is not an implementation of " + BundleActivator.class.getName());
                }
                BundleActivator bundleActivator = (BundleActivator)result;
                this.getDeploymentUnit().addAttachment(BundleActivator.class, (Object)bundleActivator);
                bundleActivator.start(this.getBundleContext());
            }
            if (this.getState() != 8) {
                throw new BundleException("Bundle has been uninstalled: " + (Object)((Object)this));
            }
            this.changeState(32);
        }
        catch (Throwable t) {
            this.changeState(16);
            this.stopInternal();
            this.destroyBundleContext();
            this.changeState(4);
            if (t instanceof BundleException) {
                throw (BundleException)t;
            }
            throw new BundleException("Cannot start bundle: " + (Object)((Object)this), t);
        }
    }

    public void stopInternal() throws BundleException {
        int priorState = this.getState();
        this.changeState(16);
        Throwable rethrow = null;
        if (priorState == 32) {
            BundleContext bundleContext = this.getBundleContext();
            BundleActivator bundleActivator = (BundleActivator)this.getDeploymentUnit().getAttachment(BundleActivator.class);
            if (bundleActivator != null && bundleContext != null) {
                try {
                    bundleActivator.stop(bundleContext);
                }
                catch (Throwable t) {
                    rethrow = t;
                }
            }
        }
        ServiceManagerPlugin plugin = this.getBundleManager().getPlugin(ServiceManagerPlugin.class);
        plugin.unregisterServices(this);
        for (ControllerContext context : this.getUsedContexts((Object)this)) {
            for (int count = this.getUsedByCount(context, (Object)this); count > 0; --count) {
                try {
                    this.removeContextInUse(context);
                    continue;
                }
                catch (Throwable t) {
                    this.log.debug((Object)("Error ungetting service: " + context), t);
                }
            }
        }
        if (this.getState() == 1) {
            throw new BundleException("Bundle uninstalled during activator stop: " + (Object)((Object)this));
        }
        this.destroyBundleContext();
        this.changeState(4);
        if (rethrow != null) {
            throw new BundleException("Error during stop of bundle: " + (Object)((Object)this), rethrow);
        }
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        if (this.getState() == 1) {
            return this.headersOnUninstall;
        }
        return super.getHeaders(locale);
    }
}

