/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.security.AccessControlContext;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.dependency.spi.dispatch.InvokeDispatchContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.Scope;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.osgi.framework.bundle.AbstractBundleState;
import org.jboss.osgi.framework.bundle.ContextComparator;
import org.jboss.osgi.framework.bundle.ControllerContextHandle;
import org.jboss.osgi.framework.bundle.DeployedBundleState;
import org.jboss.osgi.framework.bundle.MDRUtils;
import org.jboss.osgi.framework.bundle.OSGiBundleManager;
import org.jboss.osgi.framework.bundle.OSGiBundleState;
import org.jboss.osgi.framework.bundle.OSGiControllerContext;
import org.jboss.osgi.framework.bundle.OSGiScopeInfo;
import org.jboss.osgi.framework.bundle.OSGiServiceReferenceWrapper;
import org.jboss.osgi.framework.bundle.OSGiServiceRegistrationWrapper;
import org.jboss.osgi.framework.metadata.CaseInsensitiveDictionary;
import org.jboss.osgi.framework.plugins.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugins.ServiceManagerPlugin;
import org.jboss.osgi.spi.util.BundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class OSGiServiceState
extends OSGiControllerContext
implements ServiceReference,
ServiceRegistration,
InvokeDispatchContext {
    private static final RuntimePermission GET_CLASSLOADER_PERMISSION = new RuntimePermission("getClassLoader");
    private static final AtomicLong serviceIDGenerator = new AtomicLong();
    private AbstractBundleState bundleState;
    private OSGiServiceReferenceWrapper serviceReference;
    private OSGiServiceRegistrationWrapper serviceRegistration;
    private long serviceId = OSGiServiceState.getNextServiceId();
    private String[] clazzes;
    private Object serviceOrFactory;
    private boolean isServiceFactory;
    private Map<AbstractBundleState, Object> serviceCache;
    private CaseInsensitiveDictionary prevProperties;
    private CaseInsensitiveDictionary currProperties;
    private BeanInfo beanInfo;

    public OSGiServiceState(AbstractBundleState bundleState, String[] clazzes, Object service, Dictionary properties) {
        super(service, properties);
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundle state");
        }
        if (clazzes == null || clazzes.length == 0) {
            throw new IllegalArgumentException("Null or empty clazzes");
        }
        for (String clazz : clazzes) {
            if (clazz != null) continue;
            throw new IllegalArgumentException("Null class in: " + Arrays.toString(clazzes));
        }
        if (service == null) {
            throw new IllegalArgumentException("Null service");
        }
        this.bundleState = bundleState;
        this.clazzes = clazzes;
        this.serviceOrFactory = service;
        this.isServiceFactory = service instanceof ServiceFactory;
        if (!this.isServiceFactory) {
            this.checkObjClass(service);
        }
        if (properties == null) {
            properties = new Hashtable<String, Long>();
        }
        ((Dictionary)properties).put("service.id", this.getServiceId());
        ((Dictionary)properties).put("objectClass", (Long)this.getClasses());
        this.currProperties = new CaseInsensitiveDictionary(properties);
        this.serviceRegistration = new OSGiServiceRegistrationWrapper(this);
        this.initOSGiScopeInfo();
    }

    public static Long getNextServiceId() {
        return serviceIDGenerator.incrementAndGet();
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public int getServiceRanking() {
        Object ranking = this.getProperty("service.ranking");
        if (ranking != null && ranking instanceof Integer) {
            return (Integer)ranking;
        }
        return 0;
    }

    public String[] getClasses() {
        return this.clazzes;
    }

    protected void initScopeInfo() {
    }

    protected void initOSGiScopeInfo() {
        ScopeKey mutableScope;
        ScopeKey scope;
        String className = null;
        Class<?> clazz = null;
        Object target = this.serviceOrFactory;
        if (!this.isServiceFactory) {
            clazz = target.getClass();
        } else if (this.clazzes.length == 1) {
            className = this.clazzes[0];
            OSGiBundleManager manager = this.bundleState.getBundleManager();
            clazz = manager.loadClassFailsafe(this.bundleState, className);
        }
        ScopeInfo info = OSGiScopeInfo.createScopeInfo(this.getName(), className, clazz, this);
        this.setScopeInfo(info);
        if (this.bundleState instanceof OSGiBundleState) {
            DeployedBundleState obs = (DeployedBundleState)this.bundleState;
            DeploymentUnit unit = obs.getDeploymentUnit();
            scope = unit.getScope();
            mutableScope = unit.getMutableScope();
        } else {
            scope = new ScopeKey(CommonLevels.SERVER, (Object)"JBoss");
            mutableScope = null;
        }
        OSGiServiceState.mergeScopes(info.getScope(), scope);
        OSGiServiceState.mergeScopes(info.getMutableScope(), mutableScope);
    }

    protected static void mergeScopes(ScopeKey contextKey, ScopeKey unitKey) {
        if (contextKey == null) {
            return;
        }
        if (unitKey == null) {
            return;
        }
        Collection unitScopes = unitKey.getScopes();
        if (unitScopes == null || unitScopes.isEmpty()) {
            return;
        }
        for (Scope scope : unitScopes) {
            contextKey.addScope(scope);
        }
    }

    public Object getTarget() {
        return this.isServiceFactory ? null : this.serviceOrFactory;
    }

    void clearTarget() {
        this.serviceOrFactory = null;
    }

    protected Object getActualUser(ControllerContext context) {
        OSGiBundleManager manager = this.bundleState.getBundleManager();
        ServiceManagerPlugin plugin = manager.getPlugin(ServiceManagerPlugin.class);
        return plugin.getBundleForContext(context);
    }

    protected Object getTargetForActualUser(Object user) {
        if (user instanceof AbstractBundleState) {
            return this.getService((AbstractBundleState)((Object)AbstractBundleState.class.cast(user)));
        }
        return this.getTarget();
    }

    protected Object ungetTargetForActualUser(Object user) {
        if (user instanceof AbstractBundleState) {
            return this.ungetService((AbstractBundleState)((Object)AbstractBundleState.class.cast(user)));
        }
        return this.getTarget();
    }

    public Object invoke(String name, Object[] parameters, String[] signature) throws Throwable {
        return this.getBeanInfo().invoke(this.getTarget(), name, signature, parameters);
    }

    public ClassLoader getClassLoader() throws Throwable {
        return this.getClassLoaderInternal();
    }

    private ClassLoader getClassLoaderInternal() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASSLOADER_PERMISSION);
        }
        return BundleClassLoader.createClassLoader((Bundle)this.getBundle());
    }

    public Object get(String name) throws Throwable {
        return this.getBeanInfo().getProperty(this.getTarget(), name);
    }

    public void set(String name, Object value) throws Throwable {
        this.getBeanInfo().setProperty(this.getTarget(), name, value);
    }

    protected BeanInfo getBeanInfo() {
        if (this.isServiceFactory) {
            throw new IllegalArgumentException("Cannot use DispatchContext on ServiceFactory: " + (Object)((Object)this));
        }
        if (this.isUnregistered()) {
            return null;
        }
        if (this.beanInfo == null) {
            try {
                OSGiBundleManager manager = this.bundleState.getBundleManager();
                Kernel kernel = manager.getKernel();
                KernelConfigurator configurator = kernel.getConfigurator();
                Object service = this.getTarget();
                this.beanInfo = configurator.getBeanInfo(service.getClass());
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return this.beanInfo;
    }

    Object getService(AbstractBundleState bundleState) {
        if (this.isUnregistered()) {
            return null;
        }
        this.checkPermission("get", false);
        Object service = this.serviceOrFactory;
        if (this.isServiceFactory) {
            if (this.serviceCache == null) {
                this.serviceCache = new ConcurrentHashMap<AbstractBundleState, Object>();
            }
            if ((service = this.serviceCache.get((Object)bundleState)) == null) {
                ServiceFactory serviceFactory = (ServiceFactory)this.serviceOrFactory;
                try {
                    service = serviceFactory.getService(bundleState.getBundle(), this.getRegistration());
                }
                catch (Throwable t) {
                    String msg = "Cannot get service from: " + serviceFactory;
                    ServiceException serviceException = new ServiceException(msg, 3, t);
                    this.log.error((Object)"Exception in ServiceFactory.getService()", (Throwable)serviceException);
                    FrameworkEventsPlugin plugin = bundleState.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
                    plugin.fireFrameworkEvent(bundleState, 2, (Throwable)serviceException);
                    return null;
                }
                try {
                    service = this.checkObjClass(service);
                    this.serviceCache.put(bundleState, service);
                }
                catch (Throwable t) {
                    String msg = "Cannot get service from: " + serviceFactory;
                    ServiceException serviceException = new ServiceException(msg, 2);
                    this.log.error((Object)"Invalid type from ServiceFactory.getService()", (Throwable)serviceException);
                    FrameworkEventsPlugin plugin = bundleState.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
                    plugin.fireFrameworkEvent(bundleState, 2, (Throwable)serviceException);
                    return null;
                }
            }
        }
        return service;
    }

    Object ungetService(AbstractBundleState bundleState) {
        if (this.isUnregistered()) {
            return null;
        }
        Object service = this.serviceOrFactory;
        if (this.isServiceFactory) {
            if (this.serviceCache == null) {
                return null;
            }
            service = this.serviceCache.get((Object)bundleState);
            int count = this.getContextTracker().getUsedByCount((ControllerContext)this, (Object)bundleState);
            if (count == 1) {
                this.serviceCache.remove((Object)bundleState);
                ServiceFactory serviceFactory = (ServiceFactory)this.serviceOrFactory;
                try {
                    serviceFactory.ungetService(bundleState.getBundle(), this.getRegistration(), service);
                }
                catch (Throwable t) {
                    this.log.warn((Object)("Error from ungetService for " + (Object)((Object)this)), t);
                    FrameworkEventsPlugin plugin = bundleState.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
                    plugin.fireFrameworkEvent(bundleState, 16, new BundleException("Error using service factory:" + serviceFactory, t));
                }
            }
        }
        return service;
    }

    ServiceRegistration getRegistration() {
        return this.serviceRegistration;
    }

    public ServiceReference getReference() {
        this.checkUnregistered();
        return this.getReferenceInternal();
    }

    public ServiceReference getReferenceInternal() {
        if (this.serviceReference == null) {
            this.serviceReference = new OSGiServiceReferenceWrapper(this);
        }
        return this.serviceReference;
    }

    public Bundle getBundle() {
        if (this.isUnregistered()) {
            return null;
        }
        return this.bundleState.getBundleInternal();
    }

    public AbstractBundleState getBundleState() {
        return this.bundleState;
    }

    public Object getProperty(String key) {
        if (key == null) {
            return null;
        }
        return this.currProperties.get((Object)key);
    }

    public String[] getPropertyKeys() {
        ArrayList result = new ArrayList();
        if (this.currProperties != null) {
            Enumeration keys = this.currProperties.keys();
            while (keys.hasMoreElements()) {
                result.add(keys.nextElement());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setProperties(Dictionary properties) {
        this.checkUnregistered();
        this.prevProperties = this.currProperties;
        if (properties == null) {
            properties = new Hashtable<String, Long>();
        }
        ((Dictionary)properties).put("service.id", this.getServiceId());
        ((Dictionary)properties).put("objectClass", (Long)this.getClasses());
        this.currProperties = new CaseInsensitiveDictionary(properties);
        FrameworkEventsPlugin plugin = this.bundleState.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
        plugin.fireServiceEvent(this.bundleState, 2, this);
    }

    public Dictionary getPreviousProperties() {
        return this.prevProperties;
    }

    public Bundle[] getUsingBundles() {
        OSGiBundleManager manager = this.bundleState.getBundleManager();
        ServiceManagerPlugin plugin = manager.getPlugin(ServiceManagerPlugin.class);
        Set<Bundle> bundles = plugin.getUsingBundles(this);
        if (bundles.size() == 0) {
            return null;
        }
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        AbstractBundleState targetBundle = AbstractBundleState.assertBundleState(bundle);
        return MDRUtils.isAssignableTo((ControllerContext)this, this.bundleState, targetBundle, className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        this.checkUnregistered();
        try {
            this.bundleState.unregisterService(this);
        }
        finally {
            OSGiServiceState oSGiServiceState = this;
            synchronized (oSGiServiceState) {
                this.serviceRegistration = null;
            }
        }
    }

    public int compareTo(Object reference) {
        ControllerContext other;
        if (reference == null) {
            throw new IllegalArgumentException("Null reference");
        }
        if (reference instanceof ControllerContext) {
            other = (ControllerContext)reference;
        } else if (reference instanceof ControllerContextHandle) {
            other = ((ControllerContextHandle)reference).getContext();
        } else {
            throw new IllegalArgumentException(reference + " is not a service reference");
        }
        Comparator<ControllerContext> comparator = ContextComparator.getInstance();
        return comparator.compare((ControllerContext)this, other);
    }

    String toLongString() {
        StringBuilder builder = new StringBuilder();
        String desc = (String)this.getProperty("service.description");
        builder.append("Service{");
        builder.append("id=").append(this.getServiceId());
        builder.append(desc != null ? ",desc=" + desc : "");
        builder.append(",bundle=").append(this.getBundleState().getCanonicalName());
        builder.append(",classes=").append(Arrays.asList(this.getClasses()));
        builder.append(this.isServiceFactory ? ",factory=" : ",service=").append(this.serviceOrFactory);
        builder.append(",props=").append(this.currProperties);
        builder.append("}");
        return builder.toString();
    }

    void internalRegister() {
        this.checkPermission("register", true);
    }

    private Object checkObjClass(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Null object");
        }
        for (String className : this.getClasses()) {
            try {
                Class clazz = this.getBundleState().loadClass(className);
                if (clazz == null) {
                    throw new IllegalArgumentException("Cannot load '" + className + "' through: " + (Object)((Object)this.getBundleState()));
                }
                if (clazz.isInstance(object)) continue;
                throw new IllegalArgumentException(object.getClass().getName() + " does not implement " + className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(object.getClass().getName() + " cannot load class: " + className, e);
            }
        }
        return object;
    }

    void checkPermission(String action, boolean all) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        String[] clazzes = this.getClasses();
        SecurityException se = null;
        for (String clazz : clazzes) {
            try {
                ServicePermission permission = new ServicePermission(clazz, action);
                sm.checkPermission((Permission)permission);
                if (all) continue;
                return;
            }
            catch (SecurityException e) {
                if (all) {
                    throw e;
                }
                se = e;
            }
        }
        if (se != null) {
            throw se;
        }
    }

    void checkPermission(AccessControlContext accessControlContext, String action, boolean all) {
        if (System.getSecurityManager() == null) {
            return;
        }
        String[] clazzes = this.getClasses();
        SecurityException se = null;
        for (String clazz : clazzes) {
            try {
                ServicePermission permission = new ServicePermission(clazz, action);
                accessControlContext.checkPermission((Permission)permission);
                if (all) continue;
                return;
            }
            catch (SecurityException e) {
                if (all) {
                    throw e;
                }
                se = e;
            }
        }
        if (se != null) {
            throw se;
        }
    }

    boolean hasPermission() {
        try {
            this.checkPermission("get", false);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public boolean hasPermission(AccessControlContext accessControlContext) {
        try {
            this.checkPermission(accessControlContext, "get", false);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private void checkUnregistered() {
        if (this.isUnregistered()) {
            throw new IllegalStateException("Service is unregistered: " + (Object)((Object)this));
        }
    }

    synchronized boolean isUnregistered() {
        return this.serviceRegistration == null;
    }

    public boolean equals(Object obj) {
        OSGiServiceState other;
        if (obj == null) {
            return false;
        }
        if (obj instanceof OSGiServiceState) {
            other = (OSGiServiceState)((Object)obj);
        } else if (obj instanceof OSGiServiceReferenceWrapper) {
            other = ((OSGiServiceReferenceWrapper)obj).getServiceState();
        } else {
            return false;
        }
        return this == other;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Object desc = this.getProperty("service.description");
        Object rank = this.getProperty("service.ranking");
        builder.append("Service{");
        builder.append("id=").append(this.getServiceId());
        builder.append(rank != null ? ",rank=" + rank : "");
        builder.append(desc != null ? ",desc=" + desc : "");
        builder.append(",classes=").append(Arrays.asList(this.getClasses()));
        builder.append("}");
        return builder.toString();
    }
}

