/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Dictionary;
import java.util.Enumeration;
import org.osgi.framework.ServiceReference;

class ServiceRefDictionary
extends Dictionary<String, Object> {
    private ServiceReference ref;

    ServiceRefDictionary(ServiceReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Null ref");
        }
        this.ref = ref;
    }

    @Override
    public int size() {
        String[] keys = this.ref.getPropertyKeys();
        return keys != null ? keys.length : 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Enumeration<String> keys() {
        return new Enumeration<String>(){
            String[] keys;
            int index;
            int size;
            {
                this.keys = ServiceRefDictionary.this.ref.getPropertyKeys();
                this.index = 0;
                this.size = ServiceRefDictionary.this.size();
            }

            @Override
            public boolean hasMoreElements() {
                return this.index < this.size;
            }

            @Override
            public String nextElement() {
                return this.keys[this.index++];
            }
        };
    }

    @Override
    public Enumeration<Object> elements() {
        return new Enumeration<Object>(){
            String[] keys;
            int index;
            int size;
            {
                this.keys = ServiceRefDictionary.this.ref.getPropertyKeys();
                this.index = 0;
                this.size = ServiceRefDictionary.this.size();
            }

            @Override
            public boolean hasMoreElements() {
                return this.index < this.size;
            }

            @Override
            public Object nextElement() {
                return ServiceRefDictionary.this.get(this.keys[this.index++]);
            }
        };
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.ref.getProperty(key.toString());
    }

    @Override
    public Object put(String key, Object value) {
        return null;
    }

    @Override
    public Object remove(Object key) {
        return null;
    }
}

